/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CertificateList;

public class CRLAnnContent
implements DEREncodable {
    Vector certificateLists = new Vector();

    public static CRLAnnContent getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CRLAnnContent.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CRLAnnContent getInstance(Object obj) {
        if (obj instanceof CRLAnnContent) {
            return (CRLAnnContent)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CRLAnnContent((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CRLAnnContent(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            CertificateList s = CertificateList.getInstance(e.nextElement());
            this.certificateLists.addElement(s);
        }
    }

    public CRLAnnContent(CertificateList certificateList) {
        this.certificateLists.addElement(certificateList);
    }

    public void addCertificateList(CertificateList certificateList) {
        this.certificateLists.addElement(certificateList);
    }

    public CertificateList getCertificateList(int nr) {
        if (this.certificateLists.size() > nr) {
            return (CertificateList)this.certificateLists.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        for (int i = 0; i < this.certificateLists.size(); ++i) {
            v.add((DEREncodable)((CertificateList)this.certificateLists.elementAt(i)));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String p = null;
        for (int i = 0; i < this.certificateLists.size(); ++i) {
            p = p == null ? ((CertificateList)this.certificateLists.elementAt(i)).toString() : p + (CertificateList)this.certificateLists.elementAt(i);
        }
        return "CRLAnnContent: " + p;
    }
}

