/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.util;

import java.util.Collection;
import javax.servlet.ServletContext;
import javax.xml.rpc.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextAttributeExporter
implements ApplicationContextAware,
BeanNameAware {
    private final Logger log = LoggerFactory.getLogger(ServletContextAttributeExporter.class);
    private ApplicationContext appCtx;
    private String id;
    private boolean initialized;
    private Collection<String> exportedBeans;

    public ServletContextAttributeExporter(Collection<String> beans) {
        this.exportedBeans = beans;
    }

    public void destroy() throws ServiceException {
    }

    public String getId() {
        return this.id;
    }

    public void initialize() throws ServiceException {
        if (!(this.appCtx instanceof WebApplicationContext)) {
            this.log.warn("This service may only be used when services are loaded within a web application context.");
            return;
        }
        if (this.exportedBeans != null) {
            WebApplicationContext webAppCtx = (WebApplicationContext)this.appCtx;
            ServletContext servletCtx = webAppCtx.getServletContext();
            for (String beanId : this.exportedBeans) {
                Object bean = webAppCtx.getBean(beanId);
                if (bean != null) {
                    this.log.debug("Exporting bean {} to servlet context.", (Object)beanId);
                    servletCtx.setAttribute(beanId, bean);
                    continue;
                }
                this.log.warn("No {} bean located, unable to export it to the servlet context", (Object)beanId);
            }
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.appCtx = context;
    }

    public void setBeanName(String name) {
        this.id = name;
    }

    public boolean isDestroyed() {
        return false;
    }
}

