/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.standalone;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.standalone.StandaloneConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final Logger log = LoggerFactory.getLogger(ShutdownServlet.class);
    public static final String SHUTDOWN_COMMAND_HEADER_NAME = "PSEUDO_SHUTDOWN_COMMAND";
    private Thread shutdownCommandThread;

    public ShutdownServlet(Thread shutdownThread) {
        this.shutdownCommandThread = shutdownThread;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String papShutdownCommand = null;
        try {
            papShutdownCommand = StandaloneConfiguration.instance().getString("shutdown_command");
        }
        catch (PseudoServerException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.info("Shutdown request received from {}.", (Object)req.getRemoteAddr());
        if (papShutdownCommand == null) {
            this.shutdownCommandThread.start();
        } else {
            String shutdownCommand = req.getHeader(SHUTDOWN_COMMAND_HEADER_NAME);
            if (shutdownCommand != null && shutdownCommand.equals(papShutdownCommand)) {
                this.shutdownCommandThread.start();
            } else {
                log.warn("Shutdown attempted with invalid command string!");
            }
        }
    }
}

