/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.session.impl;

import java.security.SecureRandom;
import org.apache.commons.ssl.util.Hex;
import org.glite.pseudo.server.session.Session;
import org.glite.pseudo.server.session.SessionManager;
import org.glite.pseudo.server.session.StorageService;
import org.glite.pseudo.server.session.impl.SessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManagerImpl
implements SessionManager {
    private static final Logger log = LoggerFactory.getLogger(SessionManagerImpl.class);
    private StorageService sessionStore;
    private long sessionLifetime;
    private final int sessionTokenSize = 32;
    private final SecureRandom prng = new SecureRandom();

    public SessionManagerImpl(StorageService storageService, long lifetime) {
        log.debug("Initializing SessionManagerImpl..");
        this.sessionStore = storageService;
        this.sessionLifetime = lifetime;
    }

    public Session createSession(String dn) {
        log.debug("Creating a session for DN={}", (Object)dn);
        byte[] sid = new byte[32];
        this.prng.nextBytes(sid);
        String token = Hex.encode((byte[])sid);
        SessionImpl session = new SessionImpl(dn, token, this.sessionLifetime);
        log.debug("Putting the session to the storage service");
        this.sessionStore.put(session);
        return session;
    }

    public Session getSession(String dn, String token) {
        if (token == null) {
            log.error("Token cannot be null! DN was {}", (Object)dn);
            return null;
        }
        Session session = this.sessionStore.get(token);
        if (session == null || dn == null) {
            return null;
        }
        if (dn.trim().equals(session.getDN())) {
            return session;
        }
        log.warn("DN ({}) was not the same with the DN ({}) in the session store!", (Object)dn, (Object)session.getDN());
        return null;
    }
}

