/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.session.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.glite.pseudo.server.session.Session;
import org.glite.pseudo.server.session.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryStorageService
implements StorageService {
    private final Logger log = LoggerFactory.getLogger(InMemoryStorageService.class);
    private Hashtable<String, Session> sessions;

    public InMemoryStorageService(Timer timer, long frequency) {
        this.log.info("Building a new Storage Service with sweeping frequency of {}", (Object)frequency);
        this.sessions = new Hashtable();
        timer.schedule((TimerTask)new MemorySessionsCleaningTask(), 0L, frequency);
    }

    public void put(Session session) {
        this.log.debug("Putting a session {} to the storage", (Object)session.getToken());
        this.sessions.put(session.getToken(), session);
    }

    public void remove(String id) {
        if (this.sessions.containsKey(id)) {
            this.log.debug("Removing session {}", (Object)id);
            this.sessions.remove(this.sessions.get(id));
        } else {
            this.log.debug("Session {} not found to be removed", (Object)id);
        }
    }

    public Session get(String id) {
        if (this.sessions.containsKey(id)) {
            return this.sessions.get(id);
        }
        this.log.debug("Session {} not found to be returned", (Object)id);
        return null;
    }

    protected class MemorySessionsCleaningTask
    extends TimerTask {
        protected MemorySessionsCleaningTask() {
        }

        public void run() {
            InMemoryStorageService.this.log.debug("Running the cleaning task for the expired sessions");
            Enumeration enumeration = InMemoryStorageService.this.sessions.elements();
            while (enumeration.hasMoreElements()) {
                Session session = (Session)enumeration.nextElement();
                if (session.isValid()) continue;
                InMemoryStorageService.this.log.debug("Cleaning the session {} from the storage", (Object)session.getToken());
                InMemoryStorageService.this.sessions.remove(session.getToken());
            }
        }
    }
}

