/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.servlet;

import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.attribute.AttributeDefinitions;
import org.glite.pseudo.server.auditor.AuditorException;
import org.glite.pseudo.server.auditor.event.PseudoAuditEvent;
import org.glite.pseudo.server.dn.DNBuilder;
import org.glite.pseudo.server.servlet.AbstractServlet;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.glite.pseudo.server.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginServlet
extends AbstractServlet {
    private static final long serialVersionUID = 2767774493143245316L;
    private static final Logger log = LoggerFactory.getLogger(LoginServlet.class);
    private DNBuilder dnBuilder;
    private AttributeDefinitions attributeDefinitions;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.dnBuilder = HttpServletHelper.getDNBuilder(context);
        this.attributeDefinitions = HttpServletHelper.getAttributeDefinitions(context);
    }

    @Override
    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("doProcess...");
        Vector<Attribute> userAttributes = new Vector<Attribute>();
        Attribute remoteAddress = new Attribute();
        remoteAddress.setName("RemoteAddress");
        remoteAddress.setValue(request.getRemoteAddr());
        userAttributes.add(remoteAddress);
        Attribute userAgent = this.getUserAgentAttribute(request);
        userAttributes.add(userAgent);
        Attribute userDN = null;
        try {
            X509Certificate[] clientCerts = null;
            clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            if (clientCerts == null || clientCerts.length == 0) {
                throw new IOException("No certificate chain found from the HttpServletRequest!");
            }
            if (log.isDebugEnabled()) {
                log.debug("The certificate chain length: " + clientCerts.length);
                for (int i = 0; i < clientCerts.length; ++i) {
                    log.debug("Certificate #" + i + " DN: " + ((Object)clientCerts[i].getSubjectDN()).toString());
                }
            }
            userDN = new Attribute();
            userDN.setName("UserSubjectDN");
            userDN.setValue(((Object)ProxyUtils.getEndUserCertificate((X509Certificate[])clientCerts).getSubjectDN()).toString());
            userAttributes.add(userDN);
            String dn = this.dnBuilder.createDN(userAttributes);
            Session session = this.sessionManager.createSession(dn);
            session.setAttributes(userAttributes);
            try {
                PseudoAuditEvent dnIssue = new PseudoAuditEvent(201, dn, userAttributes);
                this.auditor.logEvent(dnIssue);
            }
            catch (AuditorException audit) {
                log.error("Audit error: ", (Throwable)audit);
            }
            log.debug("Session created: " + session);
            String authToken = session.getToken();
            String reqUrl = super.getContextUrl(request, "/certificate");
            List<CertificateExtension> extensions = this.certificatePolicy.getRequiredCertificateExtensions(userAttributes);
            this.sendLoginResponse(request, response, authToken, reqUrl, dn, extensions);
        }
        catch (Exception e) {
            log.error("Sending error message to the client", (Throwable)e);
            super.sendXMLErrorResponse(request, response, "CertInfoResponse", e.getMessage(), e);
        }
    }

    protected Attribute getUserAgentAttribute(HttpServletRequest req) {
        String userAgent = req.getHeader("User-Agent");
        if (userAgent != null) {
            Attribute userAgentAttribute = this.attributeDefinitions.createAttribute("UserAgent", userAgent);
            return userAgentAttribute;
        }
        return null;
    }

    protected void sendLoginResponse(HttpServletRequest req, HttpServletResponse res, String authToken, String requestURL, String certDN, List<CertificateExtension> certExtensions) throws IOException, ServletException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.getXMLDeclaration());
        pw.println("<CertInfoResponse>");
        pw.println("<Status>Success</Status>");
        pw.print("<AuthorizationToken>");
        pw.print(authToken);
        pw.println("</AuthorizationToken>");
        pw.print("<ServiceEndpoint>");
        pw.print(requestURL);
        pw.println("</ServiceEndpoint>");
        pw.print("<SubjectDN>");
        pw.print(certDN);
        pw.println("</SubjectDN>");
        pw.println("<CertificatePolicy>");
        if (certExtensions != null && !certExtensions.isEmpty()) {
            log.debug("Certificate extensions found, adding them to the CertInfoResponse..");
            for (CertificateExtension extension : certExtensions) {
                log.debug("Extension added: {}", (Object)extension.toXML());
                pw.println(extension.toXML());
            }
        }
        pw.println("</CertificatePolicy>");
        pw.println("</CertInfoResponse>");
        if (log.isDebugEnabled()) {
            log.debug("sending CertInfoResponse:\n" + sw.getBuffer().toString());
        }
        res.setContentType("text/xml");
        PrintWriter out = res.getWriter();
        out.println(sw.getBuffer().toString());
        out.close();
    }
}

