/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.servlet;

import javax.servlet.ServletContext;
import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.server.aaclient.AAClient;
import org.glite.pseudo.server.acl.AccessControlList;
import org.glite.pseudo.server.attribute.AttributeDefinitions;
import org.glite.pseudo.server.auditor.AuditAdmin;
import org.glite.pseudo.server.auditor.Auditor;
import org.glite.pseudo.server.caclient.CAClient;
import org.glite.pseudo.server.dn.DNBuilder;
import org.glite.pseudo.server.policy.CertificatePolicy;
import org.glite.pseudo.server.session.SessionManager;
import org.glite.pseudo.server.session.StorageService;

public class HttpServletHelper {
    public static final String SESSION_MNGR_SID_CTX_PARAM = "SessionManagerId";
    public static final String STORAGE_SERVICE_SID_CTX_PARAM = "StorageServiceId";
    public static final String AUDITOR_SID_CTX_PARAM = "AuditorId";
    public static final String AUDIT_ADMIN_SID_CTX_PARAM = "AuditAdminId";
    public static final String CA_CLIENT_SID_CTX_PARAM = "CAClientId";
    public static final String AA_CLIENT_SID_CTX_PARAM = "AAClientId";
    public static final String DN_BUILDER_SID_CTX_PARAM = "DNBuilderId";
    public static final String CERTIFICATE_POLICY_SID_CTX_PARAM = "CertificatePolicyId";
    public static final String ATTRIBUTE_DEFINITIONS_SID_CTX_PARAM = "AttributeDefinitionsId";
    public static final String ADMINISTRATOR_ACL_SID_CTX_PARAM = "AdministratorACL";
    public static final String ACL_SID_CTX_PARAM = "ACL";
    public static final String DEFAULT_SESSION_MNGR_SID = "pseudonymity.SessionManager";
    public static final String DEFAULT_STORAGE_SERVICE_SID = "pseudonymity.StorageService";
    public static final String DEFAULT_AUDITOR_SID = "pseudonymity.Auditor";
    public static final String DEFAULT_AUDIT_ADMIN_SID = "pseudonymity.AuditAdmin";
    public static final String DEFAULT_CA_CLIENT_SID = "pseudonymity.CAClient";
    public static final String DEFAULT_AA_CLIENT_SID = "pseudonymity.AAClient";
    public static final String DEFAULT_DN_BUILDER_SID = "pseudonymity.DNBuilder";
    public static final String DEFAULT_CERTIFICATE_POLICY_SID = "pseudonymity.CertificatePolicy";
    public static final String DEFAULT_ATTRIBUTE_DEFINITIONS_SID = "pseudonymity.AttributeDefinitions";
    public static final String DEFAULT_ACL_SID = "pseudonymity.ACL";
    public static final String DEFAULT_ADMINISTRATOR_ACL_SID = "pseudonymity.AdministratorACL";

    public static String getContextParam(ServletContext context, String name, String defaultValue) {
        String value = Util.safeTrimOrNullString((String)context.getInitParameter(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static SessionManager getSessionManager(ServletContext context) {
        return HttpServletHelper.getSessionManager(context, HttpServletHelper.getContextParam(context, SESSION_MNGR_SID_CTX_PARAM, DEFAULT_SESSION_MNGR_SID));
    }

    public static SessionManager getSessionManager(ServletContext context, String serviceId) {
        return (SessionManager)context.getAttribute(serviceId);
    }

    public static StorageService getStorageService(ServletContext context) {
        return HttpServletHelper.getStorageService(context, HttpServletHelper.getContextParam(context, STORAGE_SERVICE_SID_CTX_PARAM, DEFAULT_STORAGE_SERVICE_SID));
    }

    public static StorageService getStorageService(ServletContext context, String serviceId) {
        return (StorageService)context.getAttribute(serviceId);
    }

    public static Auditor getAuditor(ServletContext context) {
        return HttpServletHelper.getAuditor(context, HttpServletHelper.getContextParam(context, AUDITOR_SID_CTX_PARAM, DEFAULT_AUDITOR_SID));
    }

    public static Auditor getAuditor(ServletContext context, String serviceId) {
        return (Auditor)context.getAttribute(serviceId);
    }

    public static AuditAdmin getAuditAdmin(ServletContext context) {
        return HttpServletHelper.getAuditAdmin(context, HttpServletHelper.getContextParam(context, AUDIT_ADMIN_SID_CTX_PARAM, DEFAULT_AUDIT_ADMIN_SID));
    }

    public static AuditAdmin getAuditAdmin(ServletContext context, String serviceId) {
        return (AuditAdmin)context.getAttribute(serviceId);
    }

    public static CAClient getCAClient(ServletContext context) {
        return HttpServletHelper.getCAClient(context, HttpServletHelper.getContextParam(context, CA_CLIENT_SID_CTX_PARAM, DEFAULT_CA_CLIENT_SID));
    }

    public static CAClient getCAClient(ServletContext context, String serviceId) {
        return (CAClient)context.getAttribute(serviceId);
    }

    public static AAClient getAAClient(ServletContext context) {
        return HttpServletHelper.getAAClient(context, HttpServletHelper.getContextParam(context, AA_CLIENT_SID_CTX_PARAM, DEFAULT_AA_CLIENT_SID));
    }

    public static AAClient getAAClient(ServletContext context, String serviceId) {
        return (AAClient)context.getAttribute(serviceId);
    }

    public static DNBuilder getDNBuilder(ServletContext context) {
        return HttpServletHelper.getDNBuilder(context, HttpServletHelper.getContextParam(context, DN_BUILDER_SID_CTX_PARAM, DEFAULT_DN_BUILDER_SID));
    }

    public static DNBuilder getDNBuilder(ServletContext context, String serviceId) {
        return (DNBuilder)context.getAttribute(serviceId);
    }

    public static CertificatePolicy getCertificatePolicy(ServletContext context) {
        return HttpServletHelper.getCertificatePolicy(context, HttpServletHelper.getContextParam(context, CERTIFICATE_POLICY_SID_CTX_PARAM, DEFAULT_CERTIFICATE_POLICY_SID));
    }

    public static CertificatePolicy getCertificatePolicy(ServletContext context, String serviceId) {
        return (CertificatePolicy)context.getAttribute(serviceId);
    }

    public static AttributeDefinitions getAttributeDefinitions(ServletContext context) {
        return HttpServletHelper.getAttributeDefinitions(context, HttpServletHelper.getContextParam(context, ATTRIBUTE_DEFINITIONS_SID_CTX_PARAM, DEFAULT_ATTRIBUTE_DEFINITIONS_SID));
    }

    public static AttributeDefinitions getAttributeDefinitions(ServletContext context, String serviceId) {
        return (AttributeDefinitions)context.getAttribute(serviceId);
    }

    public static AccessControlList getAccessControlList(ServletContext context) {
        return HttpServletHelper.getAccessControlList(context, HttpServletHelper.getContextParam(context, ACL_SID_CTX_PARAM, DEFAULT_ACL_SID));
    }

    public static AccessControlList getAccessControlList(ServletContext context, String serviceId) {
        return (AccessControlList)context.getAttribute(serviceId);
    }

    public static AccessControlList getAdministratorAccessControlList(ServletContext context) {
        return HttpServletHelper.getAdministratorAccessControlList(context, HttpServletHelper.getContextParam(context, ADMINISTRATOR_ACL_SID_CTX_PARAM, DEFAULT_ADMINISTRATOR_ACL_SID));
    }

    public static AccessControlList getAdministratorAccessControlList(ServletContext context, String serviceId) {
        return (AccessControlList)context.getAttribute(serviceId);
    }
}

