/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.caclient.impl;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.caclient.CAClientException;
import org.glite.pseudo.server.caclient.CAConnection;
import org.glite.pseudo.server.caclient.CARequest;
import org.glite.pseudo.server.caclient.CAResponse;
import org.glite.pseudo.server.caclient.impl.CMPClient;
import org.glite.pseudo.server.caclient.impl.CMPRequest;
import org.glite.pseudo.server.caclient.impl.CMPResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPConnection
implements CAConnection {
    private static Logger log = LoggerFactory.getLogger(CMPConnection.class);
    private CMPClient cmpClient;
    private CMPResponse cmpResponse;

    protected CMPConnection(CMPClient caClient) {
        this.cmpClient = caClient;
        this.cmpResponse = null;
    }

    public CARequest createRequest(CertificateRequest csr) throws CAClientException {
        CMPRequest cmpRequest = new CMPRequest(csr, this.cmpClient.getCmpProperties());
        return cmpRequest;
    }

    public void sendRequest(CARequest caRequest) throws CAClientException {
        byte[] requestBytes = caRequest.getDEREncoded();
        ByteArrayEntity entity = new ByteArrayEntity(requestBytes);
        HttpPost cmpServerPost = new HttpPost(this.cmpClient.getServerUrl());
        cmpServerPost.setEntity((HttpEntity)entity);
        HttpClient httpClient = this.cmpClient.getHttpClient();
        HttpResponse postResponse = null;
        try {
            log.debug("Sending the request to the online CA url: {}", (Object)this.cmpClient.getServerUrl());
            postResponse = httpClient.execute((HttpUriRequest)cmpServerPost);
            log.debug("The response from the online CA: {}", (Object)postResponse);
        }
        catch (IOException e) {
            log.error("IO error while sending the request to the online CA.", (Throwable)e);
            throw new CAClientException(e);
        }
        this.cmpResponse = new CMPResponse(postResponse);
    }

    public CAResponse getResponse() throws CAClientException {
        if (this.cmpResponse == null) {
            throw new CAClientException("Response object is null!");
        }
        return this.cmpResponse;
    }
}

