/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.auditor.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glite.pseudo.server.attribute.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuditEvent {
    public static final int LEVEL_INFO = 1;
    public static final int LEVEL_WARN = 2;
    public static final int LEVEL_ERROR = 3;
    public static final int TYPE_AUTHORIZATION = 100;
    public static final int TYPE_CERTIFICATE = 200;
    public static final int TYPE_SYSTEM = 300;
    private int level_;
    private int type_;
    private String message_ = null;
    private List<Attribute> attributes_ = null;
    private Date date_ = null;

    public AuditEvent(int type, int level, String message) {
        this.type_ = type;
        this.level_ = level;
        this.message_ = message;
        this.attributes_ = new ArrayList<Attribute>();
        this.date_ = new Date();
    }

    public AuditEvent(int type, int level, String message, List<Attribute> userInformation) {
        this(type, level, message);
        this.attributes_ = userInformation;
    }

    public int getLevel() {
        return this.level_;
    }

    public String getMessage() {
        return this.message_;
    }

    public int getType() {
        return this.type_;
    }

    public Date getDate() {
        return this.date_;
    }

    public void setDate(Date date) {
        this.date_ = date;
    }

    public List<Attribute> getAttributes() {
        return this.attributes_;
    }

    public Map<String, String> getAttributesMap() {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (Attribute attribute : this.attributes_) {
            String name = attribute.getName();
            String value = attribute.getValue();
            if (attributesMap.containsKey(name)) {
                String previousValue = (String)attributesMap.get(name);
                value = previousValue + ";" + value;
            }
            attributesMap.put(name, value);
        }
        return attributesMap;
    }

    public void setAttributes(List<Attribute> userAttributes) {
        this.attributes_ = userAttributes;
    }
}

