/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.glite.voms.contact.ProxyPolicy;

public class MyProxyCertInfo
implements DEREncodable {
    private int pathLen;
    private ProxyPolicy policy;
    private int version;

    public MyProxyCertInfo(ProxyPolicy policy, int version) {
        this.policy = policy;
        this.pathLen = -1;
        this.version = version;
    }

    public MyProxyCertInfo(int pathLenConstraint, ProxyPolicy policy, int version) {
        this.policy = policy;
        this.pathLen = pathLenConstraint;
        this.version = version;
    }

    public int getPathLenConstraint() {
        return this.pathLen;
    }

    public ProxyPolicy getProxyPolicy() {
        return this.policy;
    }

    private void setFromSeq(ASN1Sequence seq) {
        if (seq.size() == 1) {
            this.version = 3;
            this.policy = new ProxyPolicy(seq);
            this.pathLen = -1;
        } else {
            this.version = 4;
            this.pathLen = ((DERInteger)seq.getObjectAt(0)).getValue().intValue();
            this.policy = new ProxyPolicy((ASN1Sequence)seq.getObjectAt(1));
        }
    }

    public MyProxyCertInfo(ASN1Sequence seq) {
        this.setFromSeq(seq);
    }

    public MyProxyCertInfo(byte[] payload) {
        DERObject derObj = null;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(payload);
            ASN1InputStream derInputStream = new ASN1InputStream((InputStream)inStream);
            derObj = derInputStream.readObject();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert byte array: " + e.getMessage());
        }
        if (!(derObj instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Unable to convert byte array");
        }
        this.setFromSeq((ASN1Sequence)derObj);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        switch (this.version) {
            case 3: {
                if (this.pathLen != -1) {
                    vec.add((DEREncodable)new DERInteger(this.pathLen));
                }
                vec.add((DEREncodable)this.policy.getDERObject());
                break;
            }
            case 4: {
                vec.add((DEREncodable)this.policy.getDERObject());
                if (this.pathLen == -1) break;
                vec.add((DEREncodable)new DERInteger(this.pathLen));
                break;
            }
        }
        return new DERSequence((DEREncodableVector)vec);
    }
}

