/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.JCERSAPrivateKey;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;

public class PKIUtils {
    private static final Pattern emailPattern = Pattern.compile("/emailaddress", 2);
    private static final Pattern uidPattern = Pattern.compile("/USERID");
    private static final Pattern basename_pattern = Pattern.compile("(.*)\\.[^\\.]*");
    private static final String SUBJECT_KEY_IDENTIFIER = "2.5.29.14";
    private static final String AUTHORITY_KEY_IDENTIFIER = "2.5.29.35";
    private static final String PROXYCERTINFO = "1.3.6.1.5.5.7.1.14";
    private static final String PROXYCERTINFO_OLD = "1.3.6.1.4.1.3536.1.222";
    private static final String BASIC_CONSTRAINTS_IDENTIFIER = "2.5.29.19";
    private static final CertificateFactory factory;
    private static final int CERT = 1;
    private static final int CRL = 2;
    private static final int keyCertSign = 5;
    private static final int digitalSignature = 0;
    private static final Logger logger;

    public static String getHash(X509Certificate x509) {
        if (x509 != null) {
            logger.debug((Object)("Getting hash of: " + x509.getSubjectDN().getName()));
            return PKIUtils.getHash(x509.getSubjectX500Principal());
        }
        throw new IllegalArgumentException("Null certificate passed to getHash()");
    }

    public static String getHash(X509CRL crl) {
        if (crl != null) {
            return PKIUtils.getHash(crl.getIssuerX500Principal());
        }
        throw new IllegalArgumentException("Null CRL passed to getHash()");
    }

    public static String getHash(X509Principal principal) {
        if (principal != null) {
            byte[] array = principal.getEncoded();
            return PKIUtils.getHash(array);
        }
        throw new IllegalArgumentException("Null name passed to getHash()");
    }

    public static String getHash(X500Principal principal) {
        if (principal != null) {
            logger.debug((Object)("Examining: " + principal.getName()));
            byte[] array = principal.getEncoded();
            logger.debug((Object)("Hash is: " + PKIUtils.getHash(array)));
            return PKIUtils.getHash(array);
        }
        throw new IllegalArgumentException("Null name passed to getHash()");
    }

    public static String getHash(byte[] name) {
        if (name != null) {
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                logger.fatal((Object)("NO MD5! " + e.getMessage()), (Throwable)e);
                throw new IllegalStateException("NO MD5! " + e.getMessage(), e);
            }
            md.update(name);
            byte[] digest = md.digest();
            ByteBuffer bb = ByteBuffer.wrap(digest).order(ByteOrder.LITTLE_ENDIAN);
            bb.rewind();
            String initial = "00000000" + Integer.toHexString(bb.getInt());
            return initial.substring(initial.length() - 8);
        }
        throw new IllegalArgumentException("Null certificate passed to getHash()");
    }

    public static String getOpenSSLFormatPrincipal(Principal principal) {
        return PKIUtils.getOpenSSLFormatPrincipal(principal, false);
    }

    public static String getOpenSSLFormatPrincipal(Principal principal, boolean reverse) {
        X509Name name = new X509Name(principal.getName());
        Vector oids = name.getOIDs();
        Vector values = name.getValues();
        ListIterator oids_iter = oids.listIterator();
        ListIterator values_iter = values.listIterator();
        String result = "";
        String addition = "";
        while (oids_iter.hasNext()) {
            DERObjectIdentifier oid = (DERObjectIdentifier)oids_iter.next();
            String value = (String)values_iter.next();
            addition = oid.equals((Object)X509Name.C) ? "/C=" + value : (oid.equals((Object)X509Name.CN) ? "/CN=" + value : (oid.equals((Object)X509Name.DC) ? "/DC=" + value : (oid.equals((Object)X509Name.E) ? "/Email=" + value : (oid.equals((Object)X509Name.EmailAddress) ? "/Email=" + value : (oid.equals((Object)X509Name.L) ? "/L=" + value : (oid.equals((Object)X509Name.O) ? "/O=" + value : (oid.equals((Object)X509Name.OU) ? "/OU=" + value : (oid.equals((Object)X509Name.ST) ? "/ST=" + value : (oid.equals((Object)X509Name.UID) ? "/UID=" + value : "/" + oid.toString() + "=" + value)))))))));
            if (reverse) {
                result = addition + result;
                continue;
            }
            result = result + addition;
        }
        logger.debug((Object)("SSLFormat: " + result));
        return result;
    }

    public static String Normalize(String dn) {
        String newdn = emailPattern.matcher(dn).replaceAll("/Email");
        return uidPattern.matcher(newdn).replaceAll("/UID");
    }

    public static boolean DNCompare(String dn1, String dn2) {
        return PKIUtils.Normalize(dn1).equals(PKIUtils.Normalize(dn2));
    }

    public static String getBaseName(File f) {
        Matcher m = basename_pattern.matcher(f.getName());
        if (m.matches()) {
            return m.group(1);
        }
        return f.getName();
    }

    public static boolean selfIssued(X509Certificate cert) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking self issued for: " + cert.getSubjectDN().getName()));
        }
        boolean ret = PKIUtils.checkIssued(cert, cert);
        logger.debug((Object)("SelfIssued Result " + ret));
        return ret;
    }

    private static BigInteger getAuthorityCertificateSerialNumber(AuthorityKeyIdentifier akid) {
        DERObject obj = akid.getDERObject();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)obj);
        for (int i = 0; i < seq.size(); ++i) {
            DERObject realObject;
            DERObject o = (DERObject)seq.getObjectAt(i);
            if (!(o instanceof ASN1TaggedObject) || ((ASN1TaggedObject)o).getTagNo() != 2 || !((realObject = ((ASN1TaggedObject)o).getObject()) instanceof DERInteger)) continue;
            return ((DERInteger)realObject).getValue();
        }
        return null;
    }

    private static GeneralNames getAuthorityCertIssuer(AuthorityKeyIdentifier akid) {
        DERObject obj = akid.getDERObject();
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)obj);
        for (int i = 0; i < seq.size(); ++i) {
            DERObject o = (DERObject)seq.getObjectAt(i);
            if (!(o instanceof ASN1TaggedObject) || ((ASN1TaggedObject)o).getTagNo() != 1) continue;
            return GeneralNames.getInstance((ASN1TaggedObject)((DERTaggedObject)o), (boolean)false);
        }
        return null;
    }

    private static GeneralName[] getNames(GeneralNames gns) {
        DERObject obj = gns.getDERObject();
        ArrayList<GeneralName> v = new ArrayList<GeneralName>();
        ASN1Sequence seq = (ASN1Sequence)obj;
        int size = seq.size();
        for (int i = 0; i < size; ++i) {
            v.add(GeneralName.getInstance((Object)seq.getObjectAt(i)));
        }
        return v.toArray(new GeneralName[0]);
    }

    public static boolean checkIssued(X509Certificate issuer, X509Certificate issued) {
        X500Principal issuerSubject = issuer.getSubjectX500Principal();
        X500Principal issuedIssuer = issued.getIssuerX500Principal();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Is: " + issued.getSubjectDN().getName() + " issued by " + issuer.getSubjectDN().getName() + "?"));
            logger.debug((Object)("Is: " + issuedIssuer.getName() + " issued by " + issuerSubject.getName() + "?"));
            logger.debug((Object)"[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[");
        }
        if (issuerSubject.equals(issuedIssuer)) {
            logger.debug((Object)"================================");
            logger.debug((Object)"issuersSubject = issuedIssuer");
            boolean needtoskip = false;
            AuthorityKeyIdentifier akid = null;
            try {
                akid = PKIUtils.getAKID(issued);
                if (akid != null) {
                    String string = akid.toString();
                }
                needtoskip = false;
            }
            catch (Exception e) {
                logger.warn((Object)("CA: " + issuerSubject.getName() + " needs to skip akid checks due to incorrectly formatted Authority Key Identifier Extension"));
                needtoskip = true;
            }
            if (!needtoskip && akid != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("akid = " + akid));
                }
                logger.debug((Object)"Authority Key Identifier extension found in issued certificate.");
                logger.debug((Object)"Entered.");
                SubjectKeyIdentifier skid = PKIUtils.getSKID(issuer);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sid = " + skid));
                }
                if (skid != null) {
                    logger.debug((Object)"subject Key Identifier extension found in issuer certificate.");
                    logger.debug((Object)"comparing skid to akid");
                    byte[] skidValue = skid.getKeyIdentifier();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"skid");
                        StringBuilder str = new StringBuilder();
                        for (int i = 0; i < skidValue.length; ++i) {
                            str.append(Integer.toHexString(skidValue[i]));
                            str.append(' ');
                        }
                        logger.debug((Object)str.toString());
                    }
                    byte[] akidValue = akid.getKeyIdentifier();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"akid");
                        StringBuilder str = new StringBuilder();
                        for (int i = 0; i < akidValue.length; ++i) {
                            str.append(Integer.toHexString(akidValue[i]));
                            str.append(' ');
                        }
                        logger.debug((Object)str.toString());
                    }
                    logger.debug((Object)"skid/akid checking.");
                    if (!Arrays.equals(skidValue, akidValue)) {
                        return false;
                    }
                    logger.debug((Object)"skid/akid check passed.");
                }
            }
            logger.debug((Object)"]]]]]]]]]]]]]]]]]]]]]]]]");
            boolean[] keyUsage = issuer.getKeyUsage();
            if (!(PKIUtils.isCA(issuer) || (keyUsage == null || keyUsage[0]) && PKIUtils.isProxy(issued))) {
                return false;
            }
            logger.debug((Object)"CHECK ISSUED PASSED");
            return true;
        }
        logger.debug((Object)"Check Issued failed.");
        return false;
    }

    public static boolean isCA(X509Certificate cert) {
        if (cert == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Examining " + cert.getSubjectDN().getName()));
            logger.debug((Object)("Hash: " + PKIUtils.getHash(cert)));
        }
        boolean[] keyUsage = cert.getKeyUsage();
        byte[] keybytes = cert.getExtensionValue("2.5.29.15");
        if (logger.isDebugEnabled()) {
            if (keybytes != null) {
                StringBuilder str = new StringBuilder();
                str.append("Real value : ");
                for (int j = 0; j < keybytes.length; ++j) {
                    str.append(Integer.toHexString(keybytes[j]));
                    str.append(' ');
                }
                logger.debug((Object)str.toString());
                DERObject dobj = null;
                try {
                    dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(keybytes)).readObject();
                    logger.debug((Object)("Class = " + dobj.getClass()));
                    dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dobj).getOctets())).readObject();
                    logger.debug((Object)("Class = " + dobj.getClass()));
                    DERBitString bitstr = (DERBitString)dobj;
                    logger.debug((Object)("pad bits  : " + bitstr.getPadBits()));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (keyUsage != null) {
                for (int i = 0; i < keyUsage.length; ++i) {
                    logger.debug((Object)("Keyusage[" + i + "] = " + keyUsage[i]));
                }
            }
        }
        if (keyUsage != null && !keyUsage[5]) {
            logger.debug((Object)"keyUsage extension present, but CertSign bit not active.");
            return false;
        }
        int isCA = cert.getBasicConstraints();
        if (isCA == -1) {
            logger.debug((Object)"Is CA");
            return false;
        }
        logger.debug((Object)"Is not CA");
        return true;
    }

    public static boolean isProxy(X509Certificate cert) {
        if (cert == null) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Check for proxyness: " + cert.getSubjectDN().getName()));
        }
        byte[] proxy = cert.getExtensionValue(PROXYCERTINFO);
        byte[] proxy_old = cert.getExtensionValue(PROXYCERTINFO_OLD);
        if (proxy != null || proxy_old != null) {
            logger.debug((Object)"Proxyness confirmed.");
            return true;
        }
        String subject = cert.getSubjectX500Principal().getName();
        String issuer = cert.getIssuerX500Principal().getName();
        logger.debug((Object)"ENDNAME CHECK?");
        if (subject.endsWith(issuer)) {
            logger.debug((Object)"ENDNAME CHECK OK");
            String s = subject.replace(issuer, "");
            logger.debug((Object)("TO CHECK: " + s));
            if (s.equals("CN=proxy,") || s.equals("CN=limited proxy,")) {
                logger.debug((Object)"Proxyness confirmed.");
                return true;
            }
        }
        return false;
    }

    public static AuthorityKeyIdentifier getAKID(X509Certificate cert) {
        if (cert != null) {
            byte[] akid = cert.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            boolean i = false;
            if (akid != null) {
                DEROctetString string = new DEROctetString(akid);
                byte[] llist2 = string.getOctets();
                DERObject dobj = null;
                try {
                    dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(llist2)).readObject();
                    dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dobj).getOctets())).readObject();
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Erroneous encoding in Authority Key Identifier " + e.getMessage(), e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("While extracting Authority Key Identifier " + e.getMessage(), e);
                }
                return new AuthorityKeyIdentifier(ASN1Sequence.getInstance((Object)dobj));
            }
        }
        return null;
    }

    public static SubjectKeyIdentifier getSKID(X509Certificate cert) {
        byte[] akid;
        if (cert != null && (akid = cert.getExtensionValue(SUBJECT_KEY_IDENTIFIER)) != null) {
            DERObject dobj = null;
            try {
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(akid)).readObject();
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(((DEROctetString)dobj).getOctets())).readObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("While extracting Subject Key Identifier " + e.getMessage(), e);
            }
            return SubjectKeyIdentifier.getInstance((Object)dobj);
        }
        return null;
    }

    public static BasicConstraints getBasicConstraints(X509Certificate cert) {
        byte[] akid;
        if (cert != null && (akid = cert.getExtensionValue(BASIC_CONSTRAINTS_IDENTIFIER)) != null) {
            DERObject dobj = null;
            try {
                dobj = new ASN1InputStream((InputStream)new ByteArrayInputStream(akid)).readObject();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("While extracting Subject Key Identifier " + e.getMessage());
            }
            return new BasicConstraints(ASN1Sequence.getInstance((Object)dobj));
        }
        return null;
    }

    public static PrivateKey loadPrivateKey(String filename, PasswordFinder finder) {
        return PKIUtils.loadPrivateKey(new File(filename), finder);
    }

    public static PrivateKey loadPrivateKey(File file, PasswordFinder finder) {
        PEMReader pem = null;
        try {
            pem = new PEMReader((Reader)new FileReader(file), finder);
            logger.debug((Object)("pem = " + pem));
            Object read = null;
            do {
                read = pem.readObject();
                logger.debug((Object)("File is: " + file.getAbsolutePath()));
                logger.debug((Object)("Object read is: " + read));
                logger.debug((Object)("Object class is: " + read.getClass().getCanonicalName()));
            } while (!(read instanceof KeyPair) && !(read instanceof JCERSAPrivateKey) && read != null);
            if (read != null) {
                if (read instanceof KeyPair) {
                    KeyPair pair = (KeyPair)read;
                    logger.debug((Object)("key = " + pair));
                    return pair.getPrivate();
                }
                if (read instanceof JCERSAPrivateKey) {
                    logger.debug((Object)("key = " + read));
                    return (PrivateKey)read;
                }
                if (read instanceof PrivateKey) {
                    return (PrivateKey)read;
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Not a PEM format file " + file.getName(), e);
        }
    }

    public static X509Certificate[] loadCertificates(String filename) throws CertificateException {
        return PKIUtils.loadCertificates(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] loadCertificates(File file) throws CertificateException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot find file " + file.getName());
        }
        X509Certificate[] certificates = null;
        try {
            certificates = PKIUtils.loadCertificates(bis);
        }
        catch (IOException e) {
            certificates = null;
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException e) {
                logger.error((Object)("While closing: " + file.getName() + " " + e.getMessage()));
            }
        }
        return certificates;
    }

    private static X509Certificate[] loadCertificates(BufferedInputStream bis) throws CertificateException, IOException {
        int type;
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        while ((type = PKIUtils.skipToCertBeginning(bis)) != -1) {
            if (type != 1) continue;
            certificates.add(factory.generateCertificate(bis));
        }
        X509Certificate[] arr = new X509Certificate[]{};
        return certificates.toArray(arr);
    }

    public static X509CRL loadCRL(String filename) throws CRLException {
        return PKIUtils.loadCRL(new File(filename));
    }

    public static X509CRL loadCRL(File file) throws CRLException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Cannot find file " + file.getName());
        }
        X509CRL crl = null;
        try {
            crl = PKIUtils.loadCRL(bis);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot load CRL from file: " + file.getName() + " cause: " + e.getMessage());
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)("While closing: " + file.getName() + " " + e.getMessage()));
            }
        }
        return crl;
    }

    private static X509CRL loadCRL(BufferedInputStream bis) throws CRLException, IOException {
        X509CRL crl = null;
        if (PKIUtils.skipToCertBeginning(bis) == 2) {
            crl = (X509CRL)factory.generateCRL(bis);
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(File f) throws IOException, CertificateException, CRLException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
        int type = PKIUtils.skipToCertBeginning(bis);
        try {
            switch (type) {
                case 2: {
                    X509CRL o = PKIUtils.loadCRL(bis);
                    bis.close();
                    bis = null;
                    X509CRL x509CRL = o;
                    return x509CRL;
                }
                case 1: {
                    Vector<X509Certificate> result = new Vector<X509Certificate>(Arrays.asList(PKIUtils.loadCertificates(bis)));
                    bis.close();
                    bis = null;
                    Vector<X509Certificate> vector = result;
                    return vector;
                }
            }
            return null;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static int skipToCertBeginning(BufferedInputStream stream) throws IOException {
        int BUF_LEN = 1000;
        byte[] b = new byte[BUF_LEN];
        stream.mark(BUF_LEN + 2);
        while (stream.available() > 0) {
            int num = stream.read(b);
            String buffer = new String(b, 0, num);
            int index = buffer.indexOf("----BEGIN CERTIFICATE");
            int index2 = buffer.indexOf("----BEGIN X509 CRL");
            if (index == -1 && index2 == -1) {
                stream.reset();
                stream.skip(BUF_LEN - 100);
                stream.mark(BUF_LEN + 2);
                continue;
            }
            if (index != -1) {
                while (buffer.charAt(index - 1) == '-' && index > 0 && --index != 0) {
                }
                stream.reset();
                stream.skip(index);
                stream.mark(10000);
                return 1;
            }
            while (buffer.charAt(index2 - 1) == '-' && index2 > 0 && --index2 != 0) {
            }
            stream.reset();
            stream.skip(index2);
            stream.mark(10000);
            return 2;
        }
        return -1;
    }

    static {
        logger = Logger.getLogger(PKIUtils.class);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            factory = CertificateFactory.getInstance("X.509", "BC");
        }
        catch (NoSuchProviderException e) {
            throw new ExceptionInInitializerError("Cannot find BouncyCastle provider: " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new ExceptionInInitializerError("X.509 Certificates unsupported. " + e.getMessage());
        }
    }
}

