/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.voms.PKIUtils;

public class Namespace {
    private static Logger logger = Logger.getLogger((String)Namespace.class.getName());
    private static final Pattern splitPattern = Pattern.compile("to issuer|permit|deny|subject", 2);
    private Vector issuer = new Vector();
    private Vector subject = new Vector();
    private Vector permit = new Vector();
    private int current = -1;
    private String gname = "";

    public Namespace(File f) throws IOException {
        this.parse(f);
    }

    public String getName() {
        return this.gname;
    }

    void parse(File f) throws IOException {
        BufferedReader theBuffer = new BufferedReader(new FileReader(f));
        String s = null;
        this.gname = PKIUtils.getBaseName(f);
        StringBuilder theLine = new StringBuilder();
        while (true) {
            if ((s = theBuffer.readLine()) != null && !s.trim().startsWith("~")) {
                theLine.append(s);
            }
            if (s != null && s.endsWith("\\")) continue;
            String finalLine = theLine.toString().trim();
            String[] strings = splitPattern.split(finalLine, 0);
            if (strings.length == 4) {
                String permitCode = "";
                if (finalLine.toLowerCase().contains(" deny ")) {
                    permitCode = "DENY";
                } else if (finalLine.toLowerCase().contains(" permit ")) {
                    permitCode = "PERMIT";
                }
                if (!permitCode.equals("")) {
                    String tempIssuer = strings[1];
                    if (tempIssuer.toLowerCase().equals("self")) {
                        this.issuer.add("SELF");
                    } else {
                        this.issuer.add(tempIssuer.substring(1, strings[1].length()));
                    }
                    this.subject.add(strings[3].substring(1, strings[3].length()));
                    this.permit.add(permitCode);
                }
            }
            if (s == null) break;
        }
    }

    public int findIssuer(X509Certificate issuer) {
        return this.findIssuer(issuer, -1);
    }

    public int findIssuer(X509Certificate issuerCert, int previous) {
        String hash;
        if (previous < -1) {
            return -1;
        }
        String currentSubj = PKIUtils.getOpenSSLFormatPrincipal(issuerCert.getSubjectDN());
        String currentSubjReversed = PKIUtils.getOpenSSLFormatPrincipal(issuerCert.getSubjectDN(), true);
        int index = this.issuer.indexOf(currentSubj, previous + 1);
        if (index == -1) {
            index = this.issuer.indexOf(currentSubjReversed, previous + 1);
        }
        if (index == -1 && ((hash = PKIUtils.getHash(issuerCert)) + ".namespace").equals(this.gname)) {
            return this.issuer.indexOf("SELF", previous + 1);
        }
        return index;
    }

    public void setCurrent(int index) {
        if (index > this.issuer.size() || index < 0) {
            throw new IllegalArgumentException("Index out of bounds for Namespace " + this.gname);
        }
        this.current = index;
    }

    public String getIssuer() {
        if (this.current != -1) {
            return (String)this.issuer.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }

    public String getSubject() {
        if (this.current != -1) {
            return (String)this.subject.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }

    public boolean getPermit() {
        if (this.current != -1) {
            return this.subject.elementAt(this.current).equals("PERMIT");
        }
        throw new IllegalArgumentException("Current record must be set in Namespace object " + this.gname);
    }
}

