/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.File;
import org.apache.log4j.Logger;

class FileEndingIterator {
    static Logger logger = Logger.getLogger((String)FileEndingIterator.class.getName());
    protected String ending;
    protected boolean nextFound = false;
    protected File[] fileList;
    protected int index = 0;

    public FileEndingIterator(String path, String ending) {
        this.ending = ending;
        try {
            File directory = path.length() != 0 ? new File(path) : new File(".").getAbsoluteFile();
            this.fileList = directory.listFiles();
            this.nextFound = this.findNext();
        }
        catch (Exception e) {
            logger.error((Object)("no files found from \"" + path + "\" error: " + e.getMessage()));
            return;
        }
    }

    public File next() {
        if (!this.nextFound) {
            return null;
        }
        File current = this.fileList[this.index++];
        this.nextFound = this.findNext();
        return current;
    }

    public boolean hasNext() {
        return this.nextFound;
    }

    protected boolean findNext() {
        try {
            while (this.index < this.fileList.length && (this.fileList[this.index].isDirectory() || !this.fileList[this.index].getName().endsWith(this.ending))) {
                ++this.index;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while reading directory " + e.getMessage()));
            return false;
        }
        return this.index < this.fileList.length;
    }
}

