/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.glite.lb.LBCredentials;
import org.glite.lb.LBException;

public class SSL {
    SSLContext sctx;
    SSLSocket client;
    SSLServerSocket server;
    SSLSession sess;
    LBCredentials creds;

    void init_ctx() throws LBException {
        if (this.sctx == null) {
            if (this.creds == null) {
                throw new NullPointerException("credentials must be specfied");
            }
            this.sctx = this.creds.getSSLContext();
        }
    }

    public void setCredentials(LBCredentials lBCredentials) {
        this.creds = lBCredentials;
    }

    public Socket connect(String string, int n, int n2) throws LBException {
        this.init_ctx();
        try {
            this.client = (SSLSocket)this.sctx.getSocketFactory().createSocket();
            this.client.setEnabledProtocols(new String[]{"SSLv3"});
            this.client.setUseClientMode(true);
            this.client.setSoTimeout(n2);
            this.client.connect(new InetSocketAddress(string, n), n2);
            this.client.startHandshake();
            this.sess = this.client.getSession();
            if (this.sess == null) {
                throw new NullPointerException("null session");
            }
        }
        catch (IOException iOException) {
            throw new LBException(iOException);
        }
        return this.client;
    }

    public Socket accept(int n, int n2) throws LBException {
        SSLSocket sSLSocket;
        this.init_ctx();
        try {
            this.server = (SSLServerSocket)this.sctx.getServerSocketFactory().createServerSocket();
            this.server.setEnabledProtocols(new String[]{"SSLv3"});
            this.server.setSoTimeout(n2);
            this.server.bind(new InetSocketAddress(n));
            sSLSocket = (SSLSocket)this.server.accept();
        }
        catch (IOException iOException) {
            throw new LBException(iOException);
        }
        return sSLSocket;
    }

    public void close() throws LBException {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            throw new LBException(iOException);
        }
    }

    private static String slashDN(String string) {
        String[] stringArray = string.split(",");
        String string2 = new String();
        for (int i = stringArray.length - 1; i >= 0 && stringArray[i].indexOf("=proxy") == -1; --i) {
            string2 = string2 + "/" + stringArray[i];
        }
        return string2;
    }

    public String myDN() {
        Certificate[] certificateArray = this.sess.getLocalCertificates();
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        return SSL.slashDN(x509Certificate.getSubjectX500Principal().getName());
    }
}

