/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.glite.wsdl.types.lb.JobStatus;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class NotifParser {
    Document doc = null;
    String header = null;

    public NotifParser(String string) throws ParserConfigurationException, SAXException, IOException {
        String[] stringArray = string.split("DG.NOTIFICATION.JOBSTAT=\"", 2);
        this.header = stringArray[0];
        this.doc = this.createXML(stringArray[1]);
    }

    public JobStatus getJobInfo() throws ParserConfigurationException, SAXException, IOException {
        JobStatus jobStatus = new JobStatus();
        jobStatus.setJobId(this.evaluateXPath("//jobId").item(0).getTextContent());
        jobStatus.setOwner(this.evaluateXPath("//owner").item(0).getTextContent());
        return jobStatus;
    }

    public String getNotifId() {
        String string = this.header.split("DG.NOTIFICATION.NOTIFID=\"")[1];
        return string.substring(0, string.indexOf("\""));
    }

    private NodeList evaluateXPath(String string) {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(string);
            return (NodeList)xPathExpression.evaluate(this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    private Document createXML(String string) throws ParserConfigurationException, SAXException, IOException {
        String string2 = string.substring(0, string.length() - 1);
        String string3 = StringEscapeUtils.unescapeXml((String)string2);
        StringBuilder stringBuilder = new StringBuilder(string3);
        int n = stringBuilder.indexOf("%");
        while (n > 0) {
            if (stringBuilder.charAt(n - 1) == '>') {
                stringBuilder.delete(n, n + 3);
                if (stringBuilder.charAt(n) != '<') continue;
                n = stringBuilder.indexOf("%");
                continue;
            }
            n = stringBuilder.indexOf("%", n + 1);
        }
        string3 = stringBuilder.toString();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string3)));
    }
}

