/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.glite.lb.LBException;

public class ILProto {
    private Socket socket = null;
    private InputStream inStream = null;
    private OutputStream outStream = null;
    private static final String magicWordXXX = "6 michal";
    private static final String magicWord = "michal";
    private int min;
    private int maj;
    private String err;
    private byte[] buf;
    private int bufptr;
    private int bufsiz;

    public ILProto(Socket socket) throws IOException {
        this.socket = socket;
        this.inStream = this.socket.getInputStream();
        this.outStream = this.socket.getOutputStream();
    }

    public String receiveMessage() throws IOException {
        byte[] byArray = new byte[17];
        if (this.inStream.read(byArray, 0, 17) == -1) {
            return null;
        }
        String string = new String(byArray);
        string.trim();
        int n = Integer.parseInt(string);
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        for (int i = 0; i != n || n2 == -1; i += n2) {
            n2 = this.inStream.read(byArray2, i, n - i);
        }
        String string2 = this.checkWord(byArray2);
        if (string2 == null) {
            return null;
        }
        return string2.split(" ", 2)[1];
    }

    public void sendMessage(String string) throws IOException {
        this.newbuf(magicWord.length() + string.length() + 100);
        this.put_string(magicWord);
        this.put_string(string);
        String string2 = String.format("%16d\n", this.bufptr);
        this.outStream.write(string2.getBytes());
        this.writebuf();
        this.outStream.flush();
    }

    public int receiveReply() throws IOException, LBException {
        this.newbuf(17);
        if (this.readbuf(17) != 17) {
            throw new LBException("reading IL proto header");
        }
        int n = Integer.parseInt(new String(this.buf).trim());
        this.newbuf(n);
        if (this.readbuf(n) < n) {
            throw new LBException("incomplete IL message");
        }
        this.rewind();
        this.maj = this.get_int();
        this.min = this.get_int();
        this.err = this.get_string();
        return this.maj;
    }

    public int errMin() {
        return this.min;
    }

    public String errMsg() {
        return this.err;
    }

    private String checkWord(byte[] byArray) {
        int n = 0;
        while (byArray[n] != 10) {
            ++n;
        }
        String string = new String(byArray, 0, n + 1);
        string.trim();
        if (!string.equals(magicWordXXX)) {
            return null;
        }
        return new String(byArray, n + 1, byArray.length - n + 1);
    }

    public void sendReply(int n, int n2, String string) throws IOException {
        byte[] byArray = (new String() + n).getBytes();
        byte[] byArray2 = (new String() + n2).getBytes();
        byte[] byArray3 = string.getBytes();
        int n3 = byArray.length + byArray2.length + byArray3.length;
        byte[] byArray4 = (new String() + n3).getBytes();
        int n4 = 17 - byArray4.length;
        byte[] byArray5 = new byte[n3 + 17];
        for (int i = 0; i < n4 - 1; ++i) {
            byArray5[i] = 32;
        }
        byArray5 = this.putByte(byArray5, byArray4, n4);
        byArray5[16] = 10;
        byArray5 = this.putByte(byArray5, byArray, 17);
        byArray5 = this.putByte(byArray5, byArray2, 16 + byArray.length);
        byArray5 = this.putByte(byArray5, byArray3, 16 + byArray.length + byArray2.length);
        this.outStream.write(byArray5);
    }

    private byte[] putByte(byte[] byArray, byte[] byArray2, int n) {
        for (int i = n; i < byArray2.length + n; ++i) {
            int n2 = 0;
            byArray[i] = byArray2[n2];
            ++n2;
        }
        return byArray;
    }

    private void newbuf(int n) {
        this.buf = new byte[n];
        this.bufptr = 0;
        this.bufsiz = n;
    }

    private void rewind() {
        this.bufptr = 0;
    }

    private int readbuf(int n) throws IOException {
        int n2;
        int n3 = 0;
        while (n > 0 && (n2 = this.inStream.read(this.buf, this.bufptr, n)) > 0) {
            this.bufptr += n2;
            n -= n2;
            n3 += n2;
        }
        return n3;
    }

    private void writebuf() throws IOException {
        this.outStream.write(this.buf, 0, this.bufptr);
    }

    private void _put_int(int n) {
        String string = new String() + n;
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            this.buf[this.bufptr++] = byArray[i];
        }
    }

    private void put_int(int n) {
        this._put_int(n);
        this.buf[this.bufptr++] = 10;
    }

    private void put_string(String string) {
        byte[] byArray = string.getBytes();
        this._put_int(byArray.length);
        this.buf[this.bufptr++] = 32;
        for (int i = 0; i < byArray.length; ++i) {
            this.buf[this.bufptr++] = byArray[i];
        }
        this.buf[this.bufptr++] = 10;
    }

    private int get_int() {
        int n = 0;
        while (Character.isDigit(this.buf[this.bufptr + n])) {
            ++n;
        }
        int n2 = Integer.parseInt(new String(this.buf, this.bufptr, n));
        this.bufptr += n + 1;
        return n2;
    }

    private String get_string() {
        int n = this.get_int();
        String string = new String(this.buf, this.bufptr, n);
        this.bufptr += n + 1;
        return string;
    }
}

