/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.util.HashMap;
import org.glite.jobid.Jobid;
import org.glite.lb.Event;
import org.glite.lb.EventAbort;
import org.glite.lb.EventAccepted;
import org.glite.lb.EventCancel;
import org.glite.lb.EventChangeACL;
import org.glite.lb.EventChkpt;
import org.glite.lb.EventClear;
import org.glite.lb.EventCollectionState;
import org.glite.lb.EventCondorError;
import org.glite.lb.EventCondorMatch;
import org.glite.lb.EventCondorReject;
import org.glite.lb.EventCondorResourceUsage;
import org.glite.lb.EventCondorShadowExited;
import org.glite.lb.EventCondorShadowStarted;
import org.glite.lb.EventCondorStarterExited;
import org.glite.lb.EventCondorStarterStarted;
import org.glite.lb.EventCurDescr;
import org.glite.lb.EventDeQueued;
import org.glite.lb.EventDone;
import org.glite.lb.EventEnQueued;
import org.glite.lb.EventHelperCall;
import org.glite.lb.EventHelperReturn;
import org.glite.lb.EventListener;
import org.glite.lb.EventMatch;
import org.glite.lb.EventNotification;
import org.glite.lb.EventPBSDequeued;
import org.glite.lb.EventPBSDone;
import org.glite.lb.EventPBSError;
import org.glite.lb.EventPBSMatch;
import org.glite.lb.EventPBSPending;
import org.glite.lb.EventPBSQueued;
import org.glite.lb.EventPBSRerun;
import org.glite.lb.EventPBSResourceUsage;
import org.glite.lb.EventPBSRun;
import org.glite.lb.EventPending;
import org.glite.lb.EventPurge;
import org.glite.lb.EventReallyRunning;
import org.glite.lb.EventRefused;
import org.glite.lb.EventRegJob;
import org.glite.lb.EventResourceUsage;
import org.glite.lb.EventResubmission;
import org.glite.lb.EventResume;
import org.glite.lb.EventRunning;
import org.glite.lb.EventSuspend;
import org.glite.lb.EventTransfer;
import org.glite.lb.EventUserTag;
import org.glite.lb.Level;
import org.glite.lb.SeqCode;
import org.glite.lb.Sources;
import org.glite.lb.Timeval;
import org.glite.wsdl.types.lb.EventSource;
import org.glite.wsdl.types.lb.TagValue;

public class EventConvertor {
    private void setCommonAttributes(org.glite.wsdl.types.lb.Timeval timeval, org.glite.wsdl.types.lb.Timeval timeval2, String string, org.glite.wsdl.types.lb.Level level, Integer n, String string2, String string3, String string4, EventSource eventSource, String string5, Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (timeval2 != null) {
            event.setArrived(new Timeval(timeval2.getTvSec(), timeval2.getTvUsec()));
        }
        if (string != null) {
            event.setHost(string);
        }
        if (string2 != null) {
            event.setJobId(new Jobid(string2));
        }
        if (level != null) {
            event.setLevel(this.getLevelFromString(level.getValue()));
        }
        if (n != null) {
            event.setPriority(n);
        }
        if (string3 != null) {
            event.setSeqcode(new SeqCode(1, string3));
        }
        if (eventSource != null) {
            event.setSource(this.getSourceFromString(eventSource.getValue()));
        }
        if (string5 != null) {
            event.setSrcInstance(string5);
        }
        if (timeval != null) {
            event.setTimestamp(new Timeval(timeval.getTvSec(), timeval.getTvUsec()));
        }
        if (string4 != null) {
            event.setUser(string4);
        }
    }

    private Sources getSourceFromString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        Sources sources = new Sources(0);
        if (string.equals("UserInterface")) {
            sources = new Sources(1);
        } else if (string.equals("NetworkServer")) {
            sources = new Sources(2);
        } else if (string.equals("WorkloadManager")) {
            sources = new Sources(3);
        } else if (string.equals("BigHelper")) {
            sources = new Sources(4);
        } else if (string.equals("JobSubmission")) {
            sources = new Sources(5);
        } else if (string.equals("LogMonitor")) {
            sources = new Sources(6);
        } else if (string.equals("LRMS")) {
            sources = new Sources(7);
        } else if (string.equals("Application")) {
            sources = new Sources(8);
        } else if (string.equals("LBServer")) {
            sources = new Sources(9);
        }
        return sources;
    }

    private Level getLevelFromString(String string) {
        if (string.equals("UNDEFINED")) {
            return Level.LEVEL_UNDEFINED;
        }
        if (string.equals("EMERGENCY")) {
            return Level.LEVEL_EMERGENCY;
        }
        if (string.equals("ALERT")) {
            return Level.LEVEL_ALERT;
        }
        if (string.equals("ERROR")) {
            return Level.LEVEL_ERROR;
        }
        if (string.equals("WARNING")) {
            return Level.LEVEL_WARNING;
        }
        if (string.equals("AUTH")) {
            return Level.LEVEL_AUTH;
        }
        if (string.equals("SECURITY")) {
            return Level.LEVEL_SECURITY;
        }
        if (string.equals("USAGE")) {
            return Level.LEVEL_USAGE;
        }
        if (string.equals("SYSTEM")) {
            return Level.LEVEL_SYSTEM;
        }
        if (string.equals("IMPORTANT")) {
            return Level.LEVEL_IMPORTANT;
        }
        if (string.equals("DEBUG")) {
            return Level.LEVEL_DEBUG;
        }
        throw new IllegalArgumentException("wrong level type");
    }

    private EventAbort createEventAbort(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventAbort eventAbort = event.getAbort();
        EventAbort eventAbort2 = new EventAbort();
        if (eventAbort.getReason() != null) {
            eventAbort2.setReason(eventAbort.getReason());
        }
        this.setCommonAttributes(eventAbort.getTimestamp(), eventAbort.getArrived(), eventAbort.getHost(), eventAbort.getLevel(), eventAbort.getPriority(), eventAbort.getJobId(), eventAbort.getSeqcode(), eventAbort.getUser(), eventAbort.getSource(), eventAbort.getSrcInstance(), eventAbort2);
        return eventAbort2;
    }

    private EventAccepted createEventAccepted(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventAccepted eventAccepted = event.getAccepted();
        EventAccepted eventAccepted2 = new EventAccepted();
        Sources sources = new Sources(0);
        if (eventAccepted.getFrom() != null) {
            sources = this.getSourceFromString(eventAccepted.getFrom().getValue());
        }
        eventAccepted2.setFrom(sources);
        if (eventAccepted.getFromHost() != null) {
            eventAccepted2.setFromHost(eventAccepted.getFromHost());
        }
        if (eventAccepted.getFromInstance() != null) {
            eventAccepted2.setFromInstance(eventAccepted.getFromInstance());
        }
        if (eventAccepted.getLocalJobid() != null) {
            eventAccepted2.setLocalJobid(eventAccepted.getLocalJobid());
        }
        this.setCommonAttributes(eventAccepted.getTimestamp(), eventAccepted.getArrived(), eventAccepted.getHost(), eventAccepted.getLevel(), eventAccepted.getPriority(), eventAccepted.getJobId(), eventAccepted.getSeqcode(), eventAccepted.getUser(), eventAccepted.getSource(), eventAccepted.getSrcInstance(), eventAccepted2);
        return eventAccepted2;
    }

    private EventCancel createEventCancel(org.glite.wsdl.types.lb.Event event) {
        EventCancel eventCancel = new EventCancel();
        org.glite.wsdl.types.lb.EventCancel eventCancel2 = event.getCancel();
        if (eventCancel2.getReason() != null) {
            eventCancel.setReason(eventCancel2.getReason());
        }
        if (eventCancel2.getStatusCode() != null) {
            eventCancel.setStatusCode(EventCancel.StatusCode.valueOf(eventCancel2.getStatusCode().getValue()));
        } else {
            eventCancel.setStatusCode(EventCancel.StatusCode.UNDEFINED);
        }
        this.setCommonAttributes(eventCancel2.getTimestamp(), eventCancel2.getArrived(), eventCancel2.getHost(), eventCancel2.getLevel(), eventCancel2.getPriority(), eventCancel2.getJobId(), eventCancel2.getSeqcode(), eventCancel2.getUser(), eventCancel2.getSource(), eventCancel2.getSrcInstance(), eventCancel);
        return eventCancel;
    }

    private EventChangeACL createEventChangeACL(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventChangeACL eventChangeACL = event.getChangeACL();
        EventChangeACL eventChangeACL2 = new EventChangeACL();
        if (eventChangeACL.getOperation() != null) {
            eventChangeACL2.setOperation(EventChangeACL.Operation.valueOf(eventChangeACL.getOperation().getValue()));
        } else {
            eventChangeACL2.setOperation(EventChangeACL.Operation.UNDEFINED);
        }
        if (eventChangeACL.getPermission() != null) {
            eventChangeACL2.setPermission(EventChangeACL.Permission.valueOf(eventChangeACL.getPermission().getValue()));
        } else {
            eventChangeACL2.setPermission(EventChangeACL.Permission.UNDEFINED);
        }
        if (eventChangeACL.getPermissionType() != null) {
            eventChangeACL2.setPermissionType(EventChangeACL.PermissionType.valueOf(eventChangeACL.getPermissionType().getValue()));
        } else {
            eventChangeACL2.setPermissionType(EventChangeACL.PermissionType.UNDEFINED);
        }
        if (eventChangeACL.getUserId() != null) {
            eventChangeACL2.setUserId(eventChangeACL.getUserId());
        }
        if (eventChangeACL.getUserIdType() != null) {
            eventChangeACL2.setUserIdType(EventChangeACL.UserIdType.valueOf(eventChangeACL.getUserIdType().getValue()));
        } else {
            eventChangeACL2.setUserIdType(EventChangeACL.UserIdType.UNDEFINED);
        }
        this.setCommonAttributes(eventChangeACL.getTimestamp(), eventChangeACL.getArrived(), eventChangeACL.getHost(), eventChangeACL.getLevel(), eventChangeACL.getPriority(), eventChangeACL.getJobId(), eventChangeACL.getSeqcode(), eventChangeACL.getUser(), eventChangeACL.getSource(), eventChangeACL.getSrcInstance(), eventChangeACL2);
        return eventChangeACL2;
    }

    private EventChkpt createEventChkpt(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventChkpt eventChkpt = event.getChkpt();
        EventChkpt eventChkpt2 = new EventChkpt();
        if (eventChkpt.getClassad() != null) {
            eventChkpt2.setClassad(eventChkpt.getClassad());
        }
        if (eventChkpt.getTag() != null) {
            eventChkpt2.setTag(eventChkpt.getTag());
        }
        this.setCommonAttributes(eventChkpt.getTimestamp(), eventChkpt.getArrived(), eventChkpt.getHost(), eventChkpt.getLevel(), eventChkpt.getPriority(), eventChkpt.getJobId(), eventChkpt.getSeqcode(), eventChkpt.getUser(), eventChkpt.getSource(), eventChkpt.getSrcInstance(), eventChkpt2);
        return eventChkpt2;
    }

    private EventClear createEventClear(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventClear eventClear = event.getClear();
        EventClear eventClear2 = new EventClear();
        if (eventClear.getReason() != null) {
            eventClear2.setReason(EventClear.Reason.valueOf(eventClear.getReason().getValue()));
        } else {
            eventClear2.setReason(EventClear.Reason.UNDEFINED);
        }
        this.setCommonAttributes(eventClear.getTimestamp(), eventClear.getArrived(), eventClear.getHost(), eventClear.getLevel(), eventClear.getPriority(), eventClear.getJobId(), eventClear.getSeqcode(), eventClear.getUser(), eventClear.getSource(), eventClear.getSrcInstance(), eventClear2);
        return eventClear2;
    }

    private EventCollectionState createEventCollectionState(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCollectionState eventCollectionState = event.getCollectionState();
        EventCollectionState eventCollectionState2 = new EventCollectionState();
        if (eventCollectionState.getChild() != null) {
            eventCollectionState2.setChild(new Jobid(eventCollectionState.getChild()));
        }
        if (eventCollectionState.getChildEvent() != null) {
            eventCollectionState2.setChildEvent(eventCollectionState.getChildEvent());
        }
        if (eventCollectionState.getDoneCode() != null) {
            eventCollectionState2.setDoneCode(eventCollectionState.getDoneCode());
        }
        if (eventCollectionState.getHistogram() != null) {
            eventCollectionState2.setHistogram(eventCollectionState.getHistogram());
        }
        if (eventCollectionState.getState() != null) {
            eventCollectionState2.setState(eventCollectionState.getState());
        }
        this.setCommonAttributes(eventCollectionState.getTimestamp(), eventCollectionState.getArrived(), eventCollectionState.getHost(), eventCollectionState.getLevel(), eventCollectionState.getPriority(), eventCollectionState.getJobId(), eventCollectionState.getSeqcode(), eventCollectionState.getUser(), eventCollectionState.getSource(), eventCollectionState.getSrcInstance(), eventCollectionState2);
        return eventCollectionState2;
    }

    private EventCondorError createEventCondorError(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorError eventCondorError = event.getCondorError();
        EventCondorError eventCondorError2 = new EventCondorError();
        if (eventCondorError2.getErrorDesc() != null) {
            eventCondorError2.setErrorDesc(eventCondorError.getErrorDesc());
        }
        this.setCommonAttributes(eventCondorError.getTimestamp(), eventCondorError.getArrived(), eventCondorError.getHost(), eventCondorError.getLevel(), eventCondorError.getPriority(), eventCondorError.getJobId(), eventCondorError.getSeqcode(), eventCondorError.getUser(), eventCondorError.getSource(), eventCondorError.getSrcInstance(), eventCondorError2);
        return eventCondorError2;
    }

    private EventCondorMatch createEventCondorMatch(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorMatch eventCondorMatch = event.getCondorMatch();
        EventCondorMatch eventCondorMatch2 = new EventCondorMatch();
        if (eventCondorMatch2.getDestHost() != null) {
            eventCondorMatch2.setDestHost(eventCondorMatch.getDestHost());
        }
        if (eventCondorMatch2.getOwner() != null) {
            eventCondorMatch2.setOwner(eventCondorMatch.getOwner());
        }
        if (eventCondorMatch2.getPreempting() != null) {
            eventCondorMatch2.setPreempting(eventCondorMatch.getPreempting());
        }
        this.setCommonAttributes(eventCondorMatch.getTimestamp(), eventCondorMatch.getArrived(), eventCondorMatch.getHost(), eventCondorMatch.getLevel(), eventCondorMatch.getPriority(), eventCondorMatch.getJobId(), eventCondorMatch.getSeqcode(), eventCondorMatch.getUser(), eventCondorMatch.getSource(), eventCondorMatch.getSrcInstance(), eventCondorMatch2);
        return eventCondorMatch2;
    }

    private EventCondorReject createEventCondorReject(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorReject eventCondorReject = event.getCondorReject();
        EventCondorReject eventCondorReject2 = new EventCondorReject();
        if (eventCondorReject2.getOwner() != null) {
            eventCondorReject2.setOwner(eventCondorReject.getOwner());
        }
        if (eventCondorReject.getStatusCode() != null) {
            eventCondorReject2.setStatusCode(EventCondorReject.StatusCode.valueOf(eventCondorReject.getStatusCode().getValue()));
        } else {
            eventCondorReject2.setStatusCode(EventCondorReject.StatusCode.UNDEFINED);
        }
        this.setCommonAttributes(eventCondorReject.getTimestamp(), eventCondorReject.getArrived(), eventCondorReject.getHost(), eventCondorReject.getLevel(), eventCondorReject.getPriority(), eventCondorReject.getJobId(), eventCondorReject.getSeqcode(), eventCondorReject.getUser(), eventCondorReject.getSource(), eventCondorReject.getSrcInstance(), eventCondorReject2);
        return eventCondorReject2;
    }

    private EventCondorResourceUsage createEventCondorResourceUsage(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorResourceUsage eventCondorResourceUsage = event.getCondorResourceUsage();
        EventCondorResourceUsage eventCondorResourceUsage2 = new EventCondorResourceUsage();
        if (eventCondorResourceUsage2.getName() != null) {
            eventCondorResourceUsage2.setName(eventCondorResourceUsage.getName());
        }
        eventCondorResourceUsage2.setQuantity(eventCondorResourceUsage.getQuantity());
        if (eventCondorResourceUsage2.getUnit() != null) {
            eventCondorResourceUsage2.setUnit(eventCondorResourceUsage.getUnit());
        }
        if (eventCondorResourceUsage.getUsage() != null) {
            eventCondorResourceUsage2.setUsage(EventCondorResourceUsage.Usage.valueOf(eventCondorResourceUsage.getUsage().getValue()));
        } else {
            eventCondorResourceUsage2.setUsage(EventCondorResourceUsage.Usage.UNDEFINED);
        }
        this.setCommonAttributes(eventCondorResourceUsage.getTimestamp(), eventCondorResourceUsage.getArrived(), eventCondorResourceUsage.getHost(), eventCondorResourceUsage.getLevel(), eventCondorResourceUsage.getPriority(), eventCondorResourceUsage.getJobId(), eventCondorResourceUsage.getSeqcode(), eventCondorResourceUsage.getUser(), eventCondorResourceUsage.getSource(), eventCondorResourceUsage.getSrcInstance(), eventCondorResourceUsage2);
        return eventCondorResourceUsage2;
    }

    private EventCondorShadowExited createEventCondorShadowExited(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorShadowExited eventCondorShadowExited = event.getCondorShadowExited();
        EventCondorShadowExited eventCondorShadowExited2 = new EventCondorShadowExited();
        eventCondorShadowExited2.setShadowExitStatus(eventCondorShadowExited.getShadowExitStatus());
        eventCondorShadowExited2.setShadowPid(eventCondorShadowExited.getShadowPid());
        this.setCommonAttributes(eventCondorShadowExited.getTimestamp(), eventCondorShadowExited.getArrived(), eventCondorShadowExited.getHost(), eventCondorShadowExited.getLevel(), eventCondorShadowExited.getPriority(), eventCondorShadowExited.getJobId(), eventCondorShadowExited.getSeqcode(), eventCondorShadowExited.getUser(), eventCondorShadowExited.getSource(), eventCondorShadowExited.getSrcInstance(), eventCondorShadowExited2);
        return eventCondorShadowExited2;
    }

    private EventCondorShadowStarted createEventCondorShadowStarted(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorShadowStarted eventCondorShadowStarted = event.getCondorShadowStarted();
        EventCondorShadowStarted eventCondorShadowStarted2 = new EventCondorShadowStarted();
        if (eventCondorShadowStarted2.getShadowHost() != null) {
            eventCondorShadowStarted2.setShadowHost(eventCondorShadowStarted.getShadowHost());
        }
        eventCondorShadowStarted2.setShadowPid(eventCondorShadowStarted.getShadowPid());
        eventCondorShadowStarted2.setShadowPort(eventCondorShadowStarted.getShadowPort());
        if (eventCondorShadowStarted2.getShadowStatus() != null) {
            eventCondorShadowStarted2.setShadowStatus(eventCondorShadowStarted.getShadowStatus());
        }
        this.setCommonAttributes(eventCondorShadowStarted.getTimestamp(), eventCondorShadowStarted.getArrived(), eventCondorShadowStarted.getHost(), eventCondorShadowStarted.getLevel(), eventCondorShadowStarted.getPriority(), eventCondorShadowStarted.getJobId(), eventCondorShadowStarted.getSeqcode(), eventCondorShadowStarted.getUser(), eventCondorShadowStarted.getSource(), eventCondorShadowStarted.getSrcInstance(), eventCondorShadowStarted2);
        return eventCondorShadowStarted2;
    }

    private EventCondorStarterExited createEventCondorStarterExited(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorStarterExited eventCondorStarterExited = event.getCondorStarterExited();
        EventCondorStarterExited eventCondorStarterExited2 = new EventCondorStarterExited();
        if (eventCondorStarterExited.getJobExitStatus() != null) {
            eventCondorStarterExited2.setJobExitStatus(eventCondorStarterExited.getJobExitStatus());
        }
        if (eventCondorStarterExited.getJobPid() != null) {
            eventCondorStarterExited2.setJobPid(eventCondorStarterExited.getJobPid());
        }
        if (eventCondorStarterExited.getStarterExitStatus() != null) {
            eventCondorStarterExited2.setStarterExitStatus(eventCondorStarterExited.getStarterExitStatus());
        }
        if (eventCondorStarterExited.getStarterPid() != null) {
            eventCondorStarterExited2.setStarterPid(eventCondorStarterExited.getStarterPid());
        }
        this.setCommonAttributes(eventCondorStarterExited.getTimestamp(), eventCondorStarterExited.getArrived(), eventCondorStarterExited.getHost(), eventCondorStarterExited.getLevel(), eventCondorStarterExited.getPriority(), eventCondorStarterExited.getJobId(), eventCondorStarterExited.getSeqcode(), eventCondorStarterExited.getUser(), eventCondorStarterExited.getSource(), eventCondorStarterExited.getSrcInstance(), eventCondorStarterExited2);
        return eventCondorStarterExited2;
    }

    private EventCondorStarterStarted createEventCondorStarterStarted(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCondorStarterStarted eventCondorStarterStarted = event.getCondorStarterStarted();
        EventCondorStarterStarted eventCondorStarterStarted2 = new EventCondorStarterStarted();
        if (eventCondorStarterStarted.getStarterPid() != null) {
            eventCondorStarterStarted2.setStarterPid(eventCondorStarterStarted.getStarterPid());
        }
        if (eventCondorStarterStarted.getUniverse() != null) {
            eventCondorStarterStarted2.setUniverse(eventCondorStarterStarted.getUniverse());
        }
        this.setCommonAttributes(eventCondorStarterStarted.getTimestamp(), eventCondorStarterStarted.getArrived(), eventCondorStarterStarted.getHost(), eventCondorStarterStarted.getLevel(), eventCondorStarterStarted.getPriority(), eventCondorStarterStarted.getJobId(), eventCondorStarterStarted.getSeqcode(), eventCondorStarterStarted.getUser(), eventCondorStarterStarted.getSource(), eventCondorStarterStarted.getSrcInstance(), eventCondorStarterStarted2);
        return eventCondorStarterStarted2;
    }

    private EventCurDescr createEventCurDescr(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventCurDescr eventCurDescr = event.getCurDescr();
        EventCurDescr eventCurDescr2 = new EventCurDescr();
        if (eventCurDescr.getDescr() != null) {
            eventCurDescr2.setDescr(eventCurDescr.getDescr());
        }
        this.setCommonAttributes(eventCurDescr.getTimestamp(), eventCurDescr.getArrived(), eventCurDescr.getHost(), eventCurDescr.getLevel(), eventCurDescr.getPriority(), eventCurDescr.getJobId(), eventCurDescr.getSeqcode(), eventCurDescr.getUser(), eventCurDescr.getSource(), eventCurDescr.getSrcInstance(), eventCurDescr2);
        return eventCurDescr2;
    }

    private EventDeQueued createEventDeQueued(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventDeQueued eventDeQueued = event.getDeQueued();
        EventDeQueued eventDeQueued2 = new EventDeQueued();
        if (eventDeQueued.getLocalJobid() != null) {
            eventDeQueued2.setLocalJobid(eventDeQueued.getLocalJobid());
        }
        if (eventDeQueued.getQueue() != null) {
            eventDeQueued2.setQueue(eventDeQueued.getQueue());
        }
        this.setCommonAttributes(eventDeQueued.getTimestamp(), eventDeQueued.getArrived(), eventDeQueued.getHost(), eventDeQueued.getLevel(), eventDeQueued.getPriority(), eventDeQueued.getJobId(), eventDeQueued.getSeqcode(), eventDeQueued.getUser(), eventDeQueued.getSource(), eventDeQueued.getSrcInstance(), eventDeQueued2);
        return eventDeQueued2;
    }

    private EventDone createEventDone(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventDone eventDone = event.getDone();
        EventDone eventDone2 = new EventDone();
        eventDone2.setExitCode(eventDone.getExitCode());
        if (eventDone.getReason() != null) {
            eventDone2.setReason(eventDone.getReason());
        }
        if (eventDone.getStatusCode() != null) {
            eventDone2.setStatusCode(EventDone.StatusCode.valueOf(eventDone.getStatusCode().getValue()));
        } else {
            eventDone2.setStatusCode(EventDone.StatusCode.UNDEFINED);
        }
        this.setCommonAttributes(eventDone.getTimestamp(), eventDone.getArrived(), eventDone.getHost(), eventDone.getLevel(), eventDone.getPriority(), eventDone.getJobId(), eventDone.getSeqcode(), eventDone.getUser(), eventDone.getSource(), eventDone.getSrcInstance(), eventDone2);
        return eventDone2;
    }

    private EventEnQueued createEventEnQueued(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventEnQueued eventEnQueued = event.getEnQueued();
        EventEnQueued eventEnQueued2 = new EventEnQueued();
        if (eventEnQueued.getJob() != null) {
            eventEnQueued2.setJob(eventEnQueued.getJob());
        }
        if (eventEnQueued.getQueue() != null) {
            eventEnQueued2.setQueue(eventEnQueued.getQueue());
        }
        if (eventEnQueued.getReason() != null) {
            eventEnQueued2.setReason(eventEnQueued.getReason());
        }
        if (eventEnQueued.getResult() != null) {
            eventEnQueued2.setResult(EventEnQueued.Result.valueOf(eventEnQueued.getResult().getValue()));
        } else {
            eventEnQueued2.setResult(EventEnQueued.Result.UNDEFINED);
        }
        this.setCommonAttributes(eventEnQueued.getTimestamp(), eventEnQueued.getArrived(), eventEnQueued.getHost(), eventEnQueued.getLevel(), eventEnQueued.getPriority(), eventEnQueued.getJobId(), eventEnQueued.getSeqcode(), eventEnQueued.getUser(), eventEnQueued.getSource(), eventEnQueued.getSrcInstance(), eventEnQueued2);
        return eventEnQueued2;
    }

    private EventHelperCall createEventHelperCall(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventHelperCall eventHelperCall = event.getHelperCall();
        EventHelperCall eventHelperCall2 = new EventHelperCall();
        if (eventHelperCall.getHelperName() != null) {
            eventHelperCall2.setHelperName(eventHelperCall.getHelperName());
        }
        if (eventHelperCall.getHelperParams() != null) {
            eventHelperCall2.setHelperParams(eventHelperCall.getHelperParams());
        }
        if (eventHelperCall.getSrcRole() != null) {
            eventHelperCall2.setSrcRole(EventHelperCall.SrcRole.valueOf(eventHelperCall.getSrcRole().getValue()));
        } else {
            eventHelperCall2.setSrcRole(EventHelperCall.SrcRole.UNDEFINED);
        }
        this.setCommonAttributes(eventHelperCall.getTimestamp(), eventHelperCall.getArrived(), eventHelperCall.getHost(), eventHelperCall.getLevel(), eventHelperCall.getPriority(), eventHelperCall.getJobId(), eventHelperCall.getSeqcode(), eventHelperCall.getUser(), eventHelperCall.getSource(), eventHelperCall.getSrcInstance(), eventHelperCall2);
        return eventHelperCall2;
    }

    private EventHelperReturn createEventHelperReturn(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventHelperReturn eventHelperReturn = event.getHelperReturn();
        EventHelperReturn eventHelperReturn2 = new EventHelperReturn();
        if (eventHelperReturn.getHelperName() != null) {
            eventHelperReturn2.setHelperName(eventHelperReturn.getHelperName());
        }
        if (eventHelperReturn.getRetval() != null) {
            eventHelperReturn2.setRetval(eventHelperReturn.getRetval());
        }
        if (eventHelperReturn.getSrcRole() != null) {
            eventHelperReturn2.setSrcRole(EventHelperReturn.SrcRole.valueOf(eventHelperReturn.getSrcRole().getValue()));
        } else {
            eventHelperReturn2.setSrcRole(EventHelperReturn.SrcRole.UNDEFINED);
        }
        this.setCommonAttributes(eventHelperReturn.getTimestamp(), eventHelperReturn.getArrived(), eventHelperReturn.getHost(), eventHelperReturn.getLevel(), eventHelperReturn.getPriority(), eventHelperReturn.getJobId(), eventHelperReturn.getSeqcode(), eventHelperReturn.getUser(), eventHelperReturn.getSource(), eventHelperReturn.getSrcInstance(), eventHelperReturn2);
        return eventHelperReturn2;
    }

    private EventListener createEventListener(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventListener eventListener = event.getListener();
        EventListener eventListener2 = new EventListener();
        if (eventListener.getSvcHost() != null) {
            eventListener2.setSvcHost(eventListener.getSvcHost());
        }
        if (eventListener.getSvcName() != null) {
            eventListener2.setSvcName(eventListener.getSvcName());
        }
        eventListener2.setSvcPort(eventListener.getSvcPort());
        this.setCommonAttributes(eventListener.getTimestamp(), eventListener.getArrived(), eventListener.getHost(), eventListener.getLevel(), eventListener.getPriority(), eventListener.getJobId(), eventListener.getSeqcode(), eventListener.getUser(), eventListener.getSource(), eventListener.getSrcInstance(), eventListener2);
        return eventListener2;
    }

    private EventMatch createEventMatch(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventMatch eventMatch = event.getMatch();
        EventMatch eventMatch2 = new EventMatch();
        if (eventMatch.getDestId() != null) {
            eventMatch2.setDestId(eventMatch.getDestId());
        }
        this.setCommonAttributes(eventMatch.getTimestamp(), eventMatch.getArrived(), eventMatch.getHost(), eventMatch.getLevel(), eventMatch.getPriority(), eventMatch.getJobId(), eventMatch.getSeqcode(), eventMatch.getUser(), eventMatch.getSource(), eventMatch.getSrcInstance(), eventMatch2);
        return eventMatch2;
    }

    private EventNotification createEventNotification(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventNotification eventNotification = event.getNotification();
        EventNotification eventNotification2 = new EventNotification();
        if (eventNotification.getDestHost() != null) {
            eventNotification2.setDestHost(eventNotification.getDestHost());
        }
        eventNotification2.setDestPort(eventNotification.getDestPort());
        eventNotification2.setExpires(eventNotification.getExpires());
        if (eventNotification.getJobstat() != null) {
            eventNotification2.setJobstat(eventNotification.getJobstat());
        }
        if (eventNotification.getNotifId() != null) {
            eventNotification2.setNotifId(new Jobid(eventNotification.getNotifId()));
        }
        if (eventNotification.getOwner() != null) {
            eventNotification2.setOwner(eventNotification.getOwner());
        }
        this.setCommonAttributes(eventNotification.getTimestamp(), eventNotification.getArrived(), eventNotification.getHost(), eventNotification.getLevel(), eventNotification.getPriority(), eventNotification.getJobId(), eventNotification.getSeqcode(), eventNotification.getUser(), eventNotification.getSource(), eventNotification.getSrcInstance(), eventNotification2);
        return eventNotification2;
    }

    private EventPBSDequeued createEventPBSDequeued(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSDequeued eventPBSDequeued = event.getPBSDequeued();
        EventPBSDequeued eventPBSDequeued2 = new EventPBSDequeued();
        this.setCommonAttributes(eventPBSDequeued.getTimestamp(), eventPBSDequeued.getArrived(), eventPBSDequeued.getHost(), eventPBSDequeued.getLevel(), eventPBSDequeued.getPriority(), eventPBSDequeued.getJobId(), eventPBSDequeued.getSeqcode(), eventPBSDequeued.getUser(), eventPBSDequeued.getSource(), eventPBSDequeued.getSrcInstance(), eventPBSDequeued2);
        return eventPBSDequeued2;
    }

    private EventPBSDone createEventPBSDone(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSDone eventPBSDone = event.getPBSDone();
        EventPBSDone eventPBSDone2 = new EventPBSDone();
        if (eventPBSDone.getExitStatus() != null) {
            eventPBSDone2.setExitStatus(eventPBSDone.getExitStatus());
        }
        this.setCommonAttributes(eventPBSDone.getTimestamp(), eventPBSDone.getArrived(), eventPBSDone.getHost(), eventPBSDone.getLevel(), eventPBSDone.getPriority(), eventPBSDone.getJobId(), eventPBSDone.getSeqcode(), eventPBSDone.getUser(), eventPBSDone.getSource(), eventPBSDone.getSrcInstance(), eventPBSDone2);
        return eventPBSDone2;
    }

    private EventPBSError createEventPBSError(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSError eventPBSError = event.getPBSError();
        EventPBSError eventPBSError2 = new EventPBSError();
        if (eventPBSError.getErrorDesc() != null) {
            eventPBSError2.setErrorDesc(eventPBSError.getErrorDesc());
        }
        this.setCommonAttributes(eventPBSError.getTimestamp(), eventPBSError.getArrived(), eventPBSError.getHost(), eventPBSError.getLevel(), eventPBSError.getPriority(), eventPBSError.getJobId(), eventPBSError.getSeqcode(), eventPBSError.getUser(), eventPBSError.getSource(), eventPBSError.getSrcInstance(), eventPBSError2);
        return eventPBSError2;
    }

    private EventPBSMatch createEventPBSMatch(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSMatch eventPBSMatch = event.getPBSMatch();
        EventPBSMatch eventPBSMatch2 = new EventPBSMatch();
        if (eventPBSMatch.getDestHost() != null) {
            eventPBSMatch2.setDestHost(eventPBSMatch.getDestHost());
        }
        this.setCommonAttributes(eventPBSMatch.getTimestamp(), eventPBSMatch.getArrived(), eventPBSMatch.getHost(), eventPBSMatch.getLevel(), eventPBSMatch.getPriority(), eventPBSMatch.getJobId(), eventPBSMatch.getSeqcode(), eventPBSMatch.getUser(), eventPBSMatch.getSource(), eventPBSMatch.getSrcInstance(), eventPBSMatch2);
        return eventPBSMatch2;
    }

    private EventPBSPending createEventPBSPending(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSPending eventPBSPending = event.getPBSPending();
        EventPBSPending eventPBSPending2 = new EventPBSPending();
        if (eventPBSPending.getReason() != null) {
            eventPBSPending2.setReason(eventPBSPending.getReason());
        }
        this.setCommonAttributes(eventPBSPending.getTimestamp(), eventPBSPending.getArrived(), eventPBSPending.getHost(), eventPBSPending.getLevel(), eventPBSPending.getPriority(), eventPBSPending.getJobId(), eventPBSPending.getSeqcode(), eventPBSPending.getUser(), eventPBSPending.getSource(), eventPBSPending.getSrcInstance(), eventPBSPending2);
        return eventPBSPending2;
    }

    private EventPBSQueued createEventPBSQueued(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSQueued eventPBSQueued = event.getPBSQueued();
        EventPBSQueued eventPBSQueued2 = new EventPBSQueued();
        this.setCommonAttributes(eventPBSQueued.getTimestamp(), eventPBSQueued.getArrived(), eventPBSQueued.getHost(), eventPBSQueued.getLevel(), eventPBSQueued.getPriority(), eventPBSQueued.getJobId(), eventPBSQueued.getSeqcode(), eventPBSQueued.getUser(), eventPBSQueued.getSource(), eventPBSQueued.getSrcInstance(), eventPBSQueued2);
        return eventPBSQueued2;
    }

    private EventPBSRerun createEventPBSRerun(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSRerun eventPBSRerun = event.getPBSRerun();
        EventPBSRerun eventPBSRerun2 = new EventPBSRerun();
        this.setCommonAttributes(eventPBSRerun.getTimestamp(), eventPBSRerun.getArrived(), eventPBSRerun.getHost(), eventPBSRerun.getLevel(), eventPBSRerun.getPriority(), eventPBSRerun.getJobId(), eventPBSRerun.getSeqcode(), eventPBSRerun.getUser(), eventPBSRerun.getSource(), eventPBSRerun.getSrcInstance(), eventPBSRerun2);
        return eventPBSRerun2;
    }

    private EventPBSResourceUsage createEventPBSResourceUsage(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSResourceUsage eventPBSResourceUsage = event.getPBSResourceUsage();
        EventPBSResourceUsage eventPBSResourceUsage2 = new EventPBSResourceUsage();
        if (eventPBSResourceUsage.getUsage() != null) {
            eventPBSResourceUsage2.setUsage(EventPBSResourceUsage.Usage.valueOf(eventPBSResourceUsage.getUsage().getValue()));
        } else {
            eventPBSResourceUsage2.setUsage(EventPBSResourceUsage.Usage.UNDEFINED);
        }
        TagValue[] tagValueArray = eventPBSResourceUsage.getResources();
        if (tagValueArray != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < tagValueArray.length; ++i) {
                hashMap.put(tagValueArray[i].getTag(), tagValueArray[i].getValue());
            }
            eventPBSResourceUsage2.setResources(hashMap);
        }
        this.setCommonAttributes(eventPBSResourceUsage.getTimestamp(), eventPBSResourceUsage.getArrived(), eventPBSResourceUsage.getHost(), eventPBSResourceUsage.getLevel(), eventPBSResourceUsage.getPriority(), eventPBSResourceUsage.getJobId(), eventPBSResourceUsage.getSeqcode(), eventPBSResourceUsage.getUser(), eventPBSResourceUsage.getSource(), eventPBSResourceUsage.getSrcInstance(), eventPBSResourceUsage2);
        return eventPBSResourceUsage2;
    }

    private EventPBSRun createEventPBSRun(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPBSRun eventPBSRun = event.getPBSRun();
        EventPBSRun eventPBSRun2 = new EventPBSRun();
        if (eventPBSRun.getDestHost() != null) {
            eventPBSRun2.setDestHost(eventPBSRun.getDestHost());
        }
        if (eventPBSRun.getPid() != null) {
            eventPBSRun2.setPid(eventPBSRun.getPid());
        }
        if (eventPBSRun.getScheduler() != null) {
            eventPBSRun2.setScheduler(eventPBSRun.getScheduler());
        }
        this.setCommonAttributes(eventPBSRun.getTimestamp(), eventPBSRun.getArrived(), eventPBSRun.getHost(), eventPBSRun.getLevel(), eventPBSRun.getPriority(), eventPBSRun.getJobId(), eventPBSRun.getSeqcode(), eventPBSRun.getUser(), eventPBSRun.getSource(), eventPBSRun.getSrcInstance(), eventPBSRun2);
        return eventPBSRun2;
    }

    private EventPending createEventPending(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPending eventPending = event.getPending();
        EventPending eventPending2 = new EventPending();
        if (eventPending.getReason() != null) {
            eventPending2.setReason(eventPending.getReason());
        }
        this.setCommonAttributes(eventPending.getTimestamp(), eventPending.getArrived(), eventPending.getHost(), eventPending.getLevel(), eventPending.getPriority(), eventPending.getJobId(), eventPending.getSeqcode(), eventPending.getUser(), eventPending.getSource(), eventPending.getSrcInstance(), eventPending2);
        return eventPending2;
    }

    private EventPurge createEventPurge(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventPurge eventPurge = event.getPurge();
        EventPurge eventPurge2 = new EventPurge();
        this.setCommonAttributes(eventPurge.getTimestamp(), eventPurge.getArrived(), eventPurge.getHost(), eventPurge.getLevel(), eventPurge.getPriority(), eventPurge.getJobId(), eventPurge.getSeqcode(), eventPurge.getUser(), eventPurge.getSource(), eventPurge.getSrcInstance(), eventPurge2);
        return eventPurge2;
    }

    private EventReallyRunning createEventReallyRunning(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventReallyRunning eventReallyRunning = event.getReallyRunning();
        EventReallyRunning eventReallyRunning2 = new EventReallyRunning();
        if (eventReallyRunning.getWnSeq() != null) {
            eventReallyRunning2.setWnSeq(eventReallyRunning.getWnSeq());
        }
        this.setCommonAttributes(eventReallyRunning.getTimestamp(), eventReallyRunning.getArrived(), eventReallyRunning.getHost(), eventReallyRunning.getLevel(), eventReallyRunning.getPriority(), eventReallyRunning.getJobId(), eventReallyRunning.getSeqcode(), eventReallyRunning.getUser(), eventReallyRunning.getSource(), eventReallyRunning.getSrcInstance(), eventReallyRunning2);
        return eventReallyRunning2;
    }

    private EventRefused createEventRefused(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventRefused eventRefused = event.getRefused();
        EventRefused eventRefused2 = new EventRefused();
        if (eventRefused.getFrom() != null) {
            eventRefused2.setFrom(this.getSourceFromString(eventRefused.getFrom().getValue()));
        } else {
            eventRefused2.setFrom(new Sources(0));
        }
        if (eventRefused.getFromHost() != null) {
            eventRefused2.setFromHost(eventRefused.getFromHost());
        }
        if (eventRefused.getFromInstance() != null) {
            eventRefused2.setFromInstance(eventRefused.getFromInstance());
        }
        if (eventRefused.getReason() != null) {
            eventRefused2.setReason(eventRefused.getReason());
        }
        this.setCommonAttributes(eventRefused.getTimestamp(), eventRefused.getArrived(), eventRefused.getHost(), eventRefused.getLevel(), eventRefused.getPriority(), eventRefused.getJobId(), eventRefused.getSeqcode(), eventRefused.getUser(), eventRefused.getSource(), eventRefused.getSrcInstance(), eventRefused2);
        return eventRefused2;
    }

    private EventRegJob createEventRegJob(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventRegJob eventRegJob = event.getRegJob();
        EventRegJob eventRegJob2 = new EventRegJob();
        if (eventRegJob.getJdl() != null) {
            eventRegJob2.setJdl(eventRegJob.getJdl());
        }
        if (eventRegJob.getJobtype() != null) {
            eventRegJob2.setJobtype(EventRegJob.Jobtype.valueOf(eventRegJob.getJobtype().getValue()));
        } else {
            eventRegJob2.setJobtype(EventRegJob.Jobtype.UNDEFINED);
        }
        if (eventRegJob.getNs() != null) {
            eventRegJob2.setNs(eventRegJob.getNs());
        }
        if (eventRegJob.getNsubjobs() != null) {
            eventRegJob2.setNsubjobs(eventRegJob.getNsubjobs());
        }
        if (eventRegJob.getParent() != null) {
            eventRegJob2.setParent(new Jobid(eventRegJob.getParent()));
        }
        if (eventRegJob.getSeed() != null) {
            eventRegJob2.setSeed(eventRegJob.getSeed());
        }
        this.setCommonAttributes(eventRegJob.getTimestamp(), eventRegJob.getArrived(), eventRegJob.getHost(), eventRegJob.getLevel(), eventRegJob.getPriority(), eventRegJob.getJobId(), eventRegJob.getSeqcode(), eventRegJob.getUser(), eventRegJob.getSource(), eventRegJob.getSrcInstance(), eventRegJob2);
        return eventRegJob2;
    }

    private EventResourceUsage createEventResourceUsage(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventResourceUsage eventResourceUsage = event.getResourceUsage();
        EventResourceUsage eventResourceUsage2 = new EventResourceUsage();
        eventResourceUsage2.setQuantity(eventResourceUsage.getQuantity());
        if (eventResourceUsage.getResource() != null) {
            eventResourceUsage2.setResource(eventResourceUsage.getResource());
        }
        if (eventResourceUsage.getUnit() != null) {
            eventResourceUsage2.setUnit(eventResourceUsage.getUnit());
        }
        this.setCommonAttributes(eventResourceUsage.getTimestamp(), eventResourceUsage.getArrived(), eventResourceUsage.getHost(), eventResourceUsage.getLevel(), eventResourceUsage.getPriority(), eventResourceUsage.getJobId(), eventResourceUsage.getSeqcode(), eventResourceUsage.getUser(), eventResourceUsage.getSource(), eventResourceUsage.getSrcInstance(), eventResourceUsage2);
        return eventResourceUsage2;
    }

    private EventResubmission createEventResubmission(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventResubmission eventResubmission = event.getResubmission();
        EventResubmission eventResubmission2 = new EventResubmission();
        if (eventResubmission.getReason() != null) {
            eventResubmission2.setReason(eventResubmission.getReason());
        }
        if (eventResubmission.getResult() != null) {
            eventResubmission2.setResult(EventResubmission.Result.valueOf(eventResubmission.getResult().getValue()));
        } else {
            eventResubmission2.setResult(EventResubmission.Result.UNDEFINED);
        }
        if (eventResubmission.getTag() != null) {
            eventResubmission2.setTag(eventResubmission.getTag());
        }
        this.setCommonAttributes(eventResubmission.getTimestamp(), eventResubmission.getArrived(), eventResubmission.getHost(), eventResubmission.getLevel(), eventResubmission.getPriority(), eventResubmission.getJobId(), eventResubmission.getSeqcode(), eventResubmission.getUser(), eventResubmission.getSource(), eventResubmission.getSrcInstance(), eventResubmission2);
        return eventResubmission2;
    }

    private EventResume createEventResume(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventResume eventResume = event.getResume();
        EventResume eventResume2 = new EventResume();
        if (eventResume.getReason() != null) {
            eventResume2.setReason(eventResume.getReason());
        }
        this.setCommonAttributes(eventResume.getTimestamp(), eventResume.getArrived(), eventResume.getHost(), eventResume.getLevel(), eventResume.getPriority(), eventResume.getJobId(), eventResume.getSeqcode(), eventResume.getUser(), eventResume.getSource(), eventResume.getSrcInstance(), eventResume2);
        return eventResume2;
    }

    private EventRunning createEventRunning(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventRunning eventRunning = event.getRunning();
        EventRunning eventRunning2 = new EventRunning();
        if (eventRunning.getNode() != null) {
            eventRunning2.setNode(eventRunning.getNode());
        }
        this.setCommonAttributes(eventRunning.getTimestamp(), eventRunning.getArrived(), eventRunning.getHost(), eventRunning.getLevel(), eventRunning.getPriority(), eventRunning.getJobId(), eventRunning.getSeqcode(), eventRunning.getUser(), eventRunning.getSource(), eventRunning.getSrcInstance(), eventRunning2);
        return eventRunning2;
    }

    private EventSuspend createEventSuspend(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventSuspend eventSuspend = event.getSuspend();
        EventSuspend eventSuspend2 = new EventSuspend();
        if (eventSuspend.getReason() != null) {
            eventSuspend2.setReason(eventSuspend.getReason());
        }
        this.setCommonAttributes(eventSuspend.getTimestamp(), eventSuspend.getArrived(), eventSuspend.getHost(), eventSuspend.getLevel(), eventSuspend.getPriority(), eventSuspend.getJobId(), eventSuspend.getSeqcode(), eventSuspend.getUser(), eventSuspend.getSource(), eventSuspend.getSrcInstance(), eventSuspend2);
        return eventSuspend2;
    }

    private EventTransfer createEventTransfer(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventTransfer eventTransfer = event.getTransfer();
        EventTransfer eventTransfer2 = new EventTransfer();
        if (eventTransfer.getDestHost() != null) {
            eventTransfer2.setDestHost(eventTransfer.getDestHost());
        }
        if (eventTransfer.getDestInstance() != null) {
            eventTransfer2.setDestInstance(eventTransfer.getDestInstance());
        }
        if (eventTransfer.getDestJobid() != null) {
            eventTransfer2.setDestJobid(eventTransfer.getDestJobid());
        }
        if (eventTransfer.getDestination() != null) {
            eventTransfer2.setDestination(this.getSourceFromString(eventTransfer.getDestination().getValue()));
        } else {
            eventTransfer2.setDestination(new Sources(0));
        }
        if (eventTransfer.getJob() != null) {
            eventTransfer2.setJob(eventTransfer.getJob());
        }
        if (eventTransfer.getReason() != null) {
            eventTransfer2.setReason(eventTransfer.getReason());
        }
        if (eventTransfer.getResult() != null) {
            eventTransfer2.setResult(EventTransfer.Result.valueOf(eventTransfer.getResult().getValue()));
        } else {
            eventTransfer2.setResult(EventTransfer.Result.UNDEFINED);
        }
        this.setCommonAttributes(eventTransfer.getTimestamp(), eventTransfer.getArrived(), eventTransfer.getHost(), eventTransfer.getLevel(), eventTransfer.getPriority(), eventTransfer.getJobId(), eventTransfer.getSeqcode(), eventTransfer.getUser(), eventTransfer.getSource(), eventTransfer.getSrcInstance(), eventTransfer2);
        return eventTransfer2;
    }

    private EventUserTag createEventUserTag(org.glite.wsdl.types.lb.Event event) {
        org.glite.wsdl.types.lb.EventUserTag eventUserTag = event.getUserTag();
        EventUserTag eventUserTag2 = new EventUserTag();
        if (eventUserTag.getName() != null) {
            eventUserTag2.setName(eventUserTag.getName());
        }
        if (eventUserTag.getValue() != null) {
            eventUserTag2.setValue(eventUserTag.getValue());
        }
        this.setCommonAttributes(eventUserTag.getTimestamp(), eventUserTag.getArrived(), eventUserTag.getHost(), eventUserTag.getLevel(), eventUserTag.getPriority(), eventUserTag.getJobId(), eventUserTag.getSeqcode(), eventUserTag.getUser(), eventUserTag.getSource(), eventUserTag.getSrcInstance(), eventUserTag2);
        return eventUserTag2;
    }

    protected Event convert(org.glite.wsdl.types.lb.Event event) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        if (event.getAbort() != null) {
            return this.createEventAbort(event);
        }
        if (event.getAccepted() != null) {
            return this.createEventAccepted(event);
        }
        if (event.getCancel() != null) {
            return this.createEventCancel(event);
        }
        if (event.getChangeACL() != null) {
            return this.createEventChangeACL(event);
        }
        if (event.getChkpt() != null) {
            return this.createEventChkpt(event);
        }
        if (event.getClear() != null) {
            return this.createEventClear(event);
        }
        if (event.getCollectionState() != null) {
            return this.createEventCollectionState(event);
        }
        if (event.getCondorError() != null) {
            return this.createEventCondorError(event);
        }
        if (event.getCondorMatch() != null) {
            return this.createEventCondorMatch(event);
        }
        if (event.getCondorReject() != null) {
            return this.createEventCondorReject(event);
        }
        if (event.getCondorResourceUsage() != null) {
            return this.createEventCondorResourceUsage(event);
        }
        if (event.getCondorShadowExited() != null) {
            return this.createEventCondorShadowExited(event);
        }
        if (event.getCondorShadowStarted() != null) {
            return this.createEventCondorShadowStarted(event);
        }
        if (event.getCondorStarterExited() != null) {
            return this.createEventCondorStarterExited(event);
        }
        if (event.getCondorStarterStarted() != null) {
            return this.createEventCondorStarterStarted(event);
        }
        if (event.getCurDescr() != null) {
            return this.createEventCurDescr(event);
        }
        if (event.getDeQueued() != null) {
            return this.createEventDeQueued(event);
        }
        if (event.getDone() != null) {
            return this.createEventDone(event);
        }
        if (event.getEnQueued() != null) {
            return this.createEventEnQueued(event);
        }
        if (event.getHelperCall() != null) {
            return this.createEventHelperCall(event);
        }
        if (event.getHelperReturn() != null) {
            return this.createEventHelperReturn(event);
        }
        if (event.getListener() != null) {
            return this.createEventListener(event);
        }
        if (event.getMatch() != null) {
            return this.createEventMatch(event);
        }
        if (event.getNotification() != null) {
            return this.createEventNotification(event);
        }
        if (event.getPBSDequeued() != null) {
            return this.createEventPBSDequeued(event);
        }
        if (event.getPBSDone() != null) {
            return this.createEventPBSDone(event);
        }
        if (event.getPBSError() != null) {
            return this.createEventPBSError(event);
        }
        if (event.getPBSMatch() != null) {
            return this.createEventPBSMatch(event);
        }
        if (event.getPBSPending() != null) {
            return this.createEventPBSPending(event);
        }
        if (event.getPBSQueued() != null) {
            return this.createEventPBSQueued(event);
        }
        if (event.getPBSRerun() != null) {
            return this.createEventPBSRerun(event);
        }
        if (event.getPBSResourceUsage() != null) {
            return this.createEventPBSResourceUsage(event);
        }
        if (event.getPBSRun() != null) {
            return this.createEventPBSRun(event);
        }
        if (event.getPending() != null) {
            return this.createEventPending(event);
        }
        if (event.getPurge() != null) {
            return this.createEventPurge(event);
        }
        if (event.getReallyRunning() != null) {
            return this.createEventReallyRunning(event);
        }
        if (event.getRefused() != null) {
            return this.createEventRefused(event);
        }
        if (event.getRegJob() != null) {
            return this.createEventRegJob(event);
        }
        if (event.getResourceUsage() != null) {
            return this.createEventResourceUsage(event);
        }
        if (event.getResubmission() != null) {
            return this.createEventResubmission(event);
        }
        if (event.getResume() != null) {
            return this.createEventResume(event);
        }
        if (event.getRunning() != null) {
            return this.createEventRunning(event);
        }
        if (event.getSuspend() != null) {
            return this.createEventSuspend(event);
        }
        if (event.getTransfer() != null) {
            return this.createEventTransfer(event);
        }
        if (event.getUserTag() != null) {
            return this.createEventUserTag(event);
        }
        return null;
    }
}

