/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import org.glite.lb.Context;
import org.glite.lb.Event;
import org.glite.lb.ILFileWriter;
import org.glite.lb.LBException;

public class ContextIL
extends Context {
    private String socket;
    private String prefix;
    private int repeatWriteToFile = 5;
    private int connAttempts = 3;
    private int timeout = 3;

    native int sendToSocket(String var1, long var2, String var4, int var5, int var6, int var7);

    public ContextIL() {
        this.prefix = "/var/glite/log/dglogd.log";
    }

    public ContextIL(String string) {
        this.prefix = string;
    }

    public ContextIL(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("ContextIL prefix");
        }
        if (string2 != null && string3 == null || string2 == null && string3 != null) {
            throw new IllegalArgumentException("ContextIL both socket and lib must be set");
        }
        this.prefix = string;
        this.socket = string2;
        if (string3 != null) {
            System.loadLibrary(string3);
        }
    }

    @Override
    public void log(Event event) throws LBException {
        if (event == null) {
            throw new IllegalArgumentException("ContextIL event");
        }
        if (this.prefix == null) {
            throw new IllegalArgumentException("ContextIL prefix");
        }
        String string = "DG.LLLID=\"0\"" + super.createMessage(event) + "\n";
        String string2 = this.prefix + "." + this.getJobid().getUnique();
        Long l = ILFileWriter.write(string2, string, this.repeatWriteToFile);
        if (this.socket != null) {
            this.sendToSocket(this.socket, l, string, string.length(), this.connAttempts, this.timeout);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getRepeatWriteToFile() {
        return this.repeatWriteToFile;
    }

    public void setRepeatWriteToFile(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ContextIL repeatWriteToFile");
        }
        this.repeatWriteToFile = n;
    }

    public int getConnAttempts() {
        return this.connAttempts;
    }

    public void setConnAttempts(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ContextIL conn_attempts");
        }
        this.connAttempts = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ContextIL time_out");
        }
        this.timeout = n;
    }
}

