/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.net.Socket;
import org.glite.lb.Context;
import org.glite.lb.Event;
import org.glite.lb.ILProto;
import org.glite.lb.LBCredentials;
import org.glite.lb.LBException;
import org.glite.lb.SSL;

public class ContextDirect
extends Context {
    String server;
    int port;
    LBCredentials cred;
    ILProto il = null;
    int timeout = 20000;

    public ContextDirect() {
    }

    public ContextDirect(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("server is null");
        }
        if (n < 1 || n > 65535) {
            throw new IllegalArgumentException("port is not valid range");
        }
        this.server = string;
        this.port = n;
    }

    public void setCredentials(LBCredentials lBCredentials) {
        this.cred = lBCredentials;
        this.il = null;
    }

    @Override
    public void log(Event event) throws LBException {
        int n;
        Object object;
        if (this.il == null) {
            object = new SSL();
            ((SSL)object).setCredentials(this.cred);
            Socket socket = ((SSL)object).connect(this.server, this.port + 1, this.timeout);
            this.setUser(((SSL)object).myDN());
            try {
                this.il = new ILProto(socket);
            }
            catch (Throwable throwable) {
                throw new LBException(throwable);
            }
        }
        object = super.createMessage(event);
        try {
            this.il.sendMessage((String)object);
            n = this.il.receiveReply();
        }
        catch (Throwable throwable) {
            throw new LBException(throwable);
        }
        if (n > 0) {
            int n2 = this.il.errMin();
            String string = this.il.errMsg();
            throw new LBException("IL proto: " + n + " " + n2 + " " + string);
        }
    }
}

