/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb.examples.ssl;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;

public class MyX509TrustManager
implements X509TrustManager {
    static Logger log = Logger.getLogger(MyX509TrustManager.class);
    private final X509Certificate[] certificateAuthorities;
    private final Set trustAnchors;

    public MyX509TrustManager(X509Certificate[] x509CertificateArray) {
        this.certificateAuthorities = x509CertificateArray;
        this.trustAnchors = new HashSet();
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            this.trustAnchors.add(new TrustAnchor(x509CertificateArray[i], null));
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        log.debug((Object)"getAcceptedIssuers()");
        return this.certificateAuthorities;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        log.debug((Object)"checkClientTrusted()");
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkServerTrusted(certs: " + x509CertificateArray.length + ", authType=" + string + ")"));
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                log.debug((Object)("cert[" + i + "]=" + x509CertificateArray[i].getSubjectX500Principal().toString()));
            }
        }
        try {
            PKIXParameters pKIXParameters = new PKIXParameters(this.trustAnchors);
            pKIXParameters.setRevocationEnabled(false);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CertPath certPath = certificateFactory.generateCertPath(Arrays.asList(x509CertificateArray));
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            certPathValidator.validate(certPath, pKIXParameters);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error((Object)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            log.error((Object)invalidAlgorithmParameterException.getMessage(), (Throwable)invalidAlgorithmParameterException);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            log.error((Object)certPathValidatorException.getMessage(), (Throwable)certPathValidatorException);
            CertificateException certificateException = new CertificateException(certPathValidatorException.getMessage());
            certificateException.setStackTrace(certPathValidatorException.getStackTrace());
            throw certificateException;
        }
        log.debug((Object)"server is trusted");
    }
}

