/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb.examples.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;
import org.glite.lb.examples.ssl.ExampleSSLSocketFactory;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingLocator;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingPortType;

public class LBClientSSL {
    static Logger log = Logger.getLogger(LBClientSSL.class);

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("usage: java LBClientSSL <keystore.p12> <password> [<url>]");
            System.exit(-1);
        }
        File file = new File(stringArray[0]);
        String string = stringArray[1];
        URL uRL = new URL("https://localhost:9003/");
        if (stringArray.length == 3) {
            uRL = new URL(stringArray[2]);
        }
        KeyStore keyStore = LBClientSSL.readKeyStoreFile(file, string);
        String string2 = null;
        Certificate[] certificateArray = keyStore.aliases();
        while (certificateArray.hasMoreElements() && !keyStore.isKeyEntry(string2 = certificateArray.nextElement())) {
            string2 = null;
        }
        if (string2 == null) {
            throw new RuntimeException("the keystore contains no keys");
        }
        certificateArray = keyStore.getCertificateChain(string2);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(string2, string.toCharArray());
        X509Certificate[] x509CertificateArray = new X509Certificate[]{(X509Certificate)certificateArray[certificateArray.length - 1]};
        ExampleSSLSocketFactory.registerForAxis(certificateArray, privateKey, x509CertificateArray);
        LoggingAndBookkeepingPortType loggingAndBookkeepingPortType = new LoggingAndBookkeepingLocator().getLoggingAndBookkeeping(uRL);
        String string3 = loggingAndBookkeepingPortType.getVersion(null);
        System.out.println("LB version: " + string3);
    }

    public static KeyStore readKeyStoreFile(File file, String string) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String string2;
        if (file.getName().endsWith("ks")) {
            string2 = "JKS";
        } else if (file.getName().endsWith(".p12")) {
            string2 = "PKCS12";
        } else {
            throw new IOException("Only JKS (*ks) and PKCS12 (*.p12) files are supported ");
        }
        KeyStore keyStore = KeyStore.getInstance(string2);
        keyStore.load(new FileInputStream(file), string != null ? string.toCharArray() : null);
        return keyStore;
    }
}

