/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb.examples.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.components.net.DefaultSocketFactory;
import org.apache.axis.components.net.SecureSocketFactory;
import org.apache.log4j.Logger;
import org.glite.lb.examples.ssl.MyX509KeyManager;
import org.glite.lb.examples.ssl.MyX509TrustManager;

public class ExampleSSLSocketFactory
extends DefaultSocketFactory
implements SecureSocketFactory {
    static Logger log = Logger.getLogger(ExampleSSLSocketFactory.class);
    static Certificate[] cChain = null;
    static PrivateKey pKey = null;
    static X509Certificate[] certAuths = null;
    protected SSLSocketFactory sslFactory = null;

    static void registerForAxis(Certificate[] certificateArray, PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        log.debug((Object)"registering as Axis SecureSocketFactory");
        cChain = certificateArray;
        pKey = privateKey;
        certAuths = x509CertificateArray;
        System.setProperty("org.apache.axis.components.net.SecureSocketFactory", ExampleSSLSocketFactory.class.getName());
    }

    public ExampleSSLSocketFactory(Hashtable hashtable) throws Exception {
        super(hashtable);
        SSLContext sSLContext = SSLContext.getInstance("SSL");
        KeyManager[] keyManagerArray = new KeyManager[]{new MyX509KeyManager(cChain, pKey)};
        TrustManager[] trustManagerArray = new TrustManager[]{new MyX509TrustManager(certAuths)};
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("attributes: " + hashtable));
            log.debug((Object)("SSLContext.provider: " + sSLContext.getProvider().getInfo()));
        }
        this.sslFactory = sSLContext.getSocketFactory();
    }

    public Socket create(String string, int n, StringBuffer stringBuffer, BooleanHolder booleanHolder) throws IOException, SocketException {
        int n2;
        log.debug((Object)("create(" + string + ":" + n + ")"));
        SSLSocket sSLSocket = (SSLSocket)this.sslFactory.createSocket();
        sSLSocket.setEnabledProtocols(new String[]{"SSLv3"});
        String[] stringArray = sSLSocket.getEnabledCipherSuites();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].indexOf("RC4") != -1) continue;
            arrayList.add(stringArray[n2]);
        }
        sSLSocket.setEnabledCipherSuites(arrayList.toArray(new String[arrayList.size()]));
        sSLSocket.setUseClientMode(true);
        sSLSocket.setSoTimeout(30000);
        sSLSocket.connect(new InetSocketAddress(string, n), 3000);
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            log.debug((Object)"sess is null");
            return sSLSocket;
        }
        if (log.isDebugEnabled()) {
            byte[] byArray = sSLSession.getId();
            StringBuffer stringBuffer2 = new StringBuffer(byArray.length * 2);
            for (n2 = 0; n2 < byArray.length; ++n2) {
                stringBuffer2.append(Integer.toHexString(byArray[n2] < 0 ? 256 - byArray[n2] : byArray[n2]));
            }
            log.debug((Object)("SSLSession.id = " + stringBuffer2.toString()));
            log.debug((Object)("cipherSuite   = " + sSLSession.getCipherSuite()));
            log.debug((Object)("protocol      = " + sSLSession.getProtocol()));
            log.debug((Object)("creationTime    = " + new Date(sSLSession.getCreationTime())));
            log.debug((Object)("lastAccessedTime= " + new Date(sSLSession.getLastAccessedTime())));
        }
        return sSLSocket;
    }
}

