
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <stdlib.h>
#include "libpbs.h"
#include "list_link.h"
#include "server_limits.h"
#include "attribute.h"
#include "credential.h"
#include "batch_request.h"
#include "dis.h"

int
decode_DIS_ReturnFiles(int sock, struct batch_request *preq)
  {

  struct rq_returnfiles *prfs;
  int   rc;

  prfs = &preq->rq_ind.rq_returnfiles;

  if ((rc = disrfst(sock, PBS_MAXSVRJOBID, prfs->rq_jobid)) != 0)
    return rc;

  prfs->rq_return_stdout = disrsi(sock, &rc);

  if (rc != 0)
    return rc;

  prfs->rq_return_stderr = disrsi(sock, &rc);

  if (rc != 0)
    return rc;

  return 0;
  }


int
tcp_decode_DIS_ReturnFiles(int sock, struct batch_request *preq)
  {

  struct rq_returnfiles *prfs;
  int   rc;

  prfs = &preq->rq_ind.rq_returnfiles;

  if ((rc = tcp_disrfst(sock, PBS_MAXSVRJOBID, prfs->rq_jobid)) != 0)
    return rc;

  prfs->rq_return_stdout = tcp_disrsi(sock, &rc);

  if (rc != 0)
    return rc;

  prfs->rq_return_stderr = tcp_disrsi(sock, &rc);

  if (rc != 0)
    return rc;

  return 0;
  }
