#include <pbs_config.h>   /* the master config generated by configure */

#include <stdlib.h>
#include <string.h>
#include "pbs_ifl.h"

#include "log.h"
#include "list_link.h"
#include "attribute.h"
#include "resource.h"
#include "pbs_error.h"

/*
 * decode_tokens - validate the token request
 *
 *	Returns: 0 if ok
 *		>0 error number if error
 *		*patr elements set
 */

int decode_tokens(

  struct attribute *patr,
  char *name,             /* attribute name */
  char *rescn,            /* resource name, unused here */
  char *val               /* attribute value */
  )

  {
  int ret = 0;
  char * colon;
  float count;

  if(val != NULL){
    ret = PBSE_BADATVAL; /* Assume bad until proven otherwise */
    colon = strstr(val, ":");
    if(colon != NULL){
      count = atof(++colon);
      if(count > 0.0 && count < 1000.0){
	ret = 0;
      }
    }
  }

  if(ret == 0){
    ret = decode_str(patr, name, rescn, val);
  }

  return ret;
}
